/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.ion;

import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.ion.IonWriteContext;
import com.fasterxml.jackson.dataformat.ion.PackageVersion;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;

public class IonGenerator
extends GeneratorBase {
    protected final IonWriter _writer;
    protected final boolean _ionWriterIsManaged;
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected final Closeable _destination;

    public IonGenerator(int jsonFeatures, int ionFeatures, ObjectCodec codec, IonWriter ion, boolean ionWriterIsManaged, IOContext ctxt, Closeable dst) {
        super(jsonFeatures, codec);
        this._writeContext = IonWriteContext.createRootContext(this._writeContext.getDupDetector());
        this._formatFeatures = ionFeatures;
        this._writer = ion;
        this._ionWriterIsManaged = ionWriterIsManaged;
        this._ioContext = ctxt;
        this._destination = dst;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._ionWriterIsManaged) {
                this._writer.close();
            }
            if (this._ioContext.isResourceManaged()) {
                this._destination.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM) && this._destination instanceof Flushable) {
                ((Flushable)((Object)this._destination)).flush();
            }
        }
    }

    public void flush() throws IOException {
        Object dst;
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM) && (dst = this._ioContext.contentReference().getRawContent()) instanceof Flushable) {
            ((Flushable)dst).flush();
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public boolean canWriteTypeId() {
        return Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    public boolean canWriteBinaryNatively() {
        return true;
    }

    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_BINARY_WRITE_CAPABILITIES;
    }

    public void writeNumber(int value) throws IOException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeInt((long)value);
    }

    public void writeNumber(long value) throws IOException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeInt(value);
    }

    public void writeNumber(BigInteger value) throws IOException {
        if (value == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write numeric value");
            this._writer.writeInt(value);
        }
    }

    public void writeNumber(double value) throws IOException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeFloat(value);
    }

    public void writeNumber(float value) throws IOException {
        this._verifyValueWrite("write numeric value");
        this._writer.writeFloat((double)value);
    }

    public void writeNumber(BigDecimal value) throws IOException {
        if (value == null) {
            this.writeNull();
        } else {
            this._verifyValueWrite("write numeric value");
            this._writer.writeDecimal(value);
        }
    }

    public void writeNumber(String value) throws IOException, UnsupportedOperationException {
        this.writeString(value);
    }

    public void writeSymbol(String value) throws IOException {
        this._verifyValueWrite("write symbol value");
        this._writer.writeSymbol(value);
    }

    public void annotateNextValue(String annotation) {
        this._writer.addTypeAnnotation(annotation);
    }

    public void writeDate(Calendar value) throws IOException {
        this._verifyValueWrite("write date value");
        this._writer.writeTimestamp(Timestamp.forCalendar((Calendar)value));
    }

    public void writeString(String value) throws IOException {
        this._verifyValueWrite("write text value");
        this._writer.writeString(value);
    }

    public void writeString(char[] buffer, int offset, int length) throws IOException {
        this.writeString(new String(buffer, offset, length));
    }

    public void writeUTF8String(byte[] buffer, int offset, int length) throws IOException {
        this.writeString(new String(buffer, offset, length, StandardCharsets.UTF_8));
    }

    public void writeRaw(String value) throws IOException {
        this._reportNoRaw();
    }

    public void writeRaw(char value) throws IOException {
        this._reportNoRaw();
    }

    public void writeRaw(String value, int arg1, int arg2) throws IOException {
        this._reportNoRaw();
    }

    public void writeRaw(char[] value, int arg1, int arg2) throws IOException {
        this._reportNoRaw();
    }

    public void writeRawValue(String value) throws IOException {
        this._reportNoRaw();
    }

    public void writeRawValue(String value, int arg1, int arg2) throws IOException {
        this._reportNoRaw();
    }

    public void writeRawValue(char[] value, int arg1, int arg2) throws IOException {
        this._reportNoRaw();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this._reportNoRaw();
    }

    public void writeBinary(Base64Variant b64v, byte[] data, int offset, int length) throws IOException {
        this._verifyValueWrite("write binary data");
        this._writer.writeBlob(data, offset, length);
    }

    public void writeBoolean(boolean value) throws IOException {
        this._verifyValueWrite("write boolean");
        this._writer.writeBool(value);
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null");
        this._writer.writeNull();
    }

    public void writeNull(IonType ionType) throws IOException {
        this._verifyValueWrite("write null");
        this._writer.writeNull(ionType);
    }

    public void writeObject(Object pojo) throws IOException {
        if (pojo == null) {
            this.writeNull();
        } else {
            if (this._objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined for the generator, can not serialize regular Java objects");
            }
            this._objectCodec.writeValue((JsonGenerator)this, pojo);
        }
    }

    public void writeValue(IonValue value) throws IOException {
        this._verifyValueWrite("write ion value");
        if (value == null) {
            this._writer.writeNull();
        } else {
            value.writeTo(this._writer);
        }
    }

    public void writeValue(Timestamp value) throws IOException {
        this._verifyValueWrite("write timestamp");
        if (value == null) {
            this._writer.writeNull();
        } else {
            this._writer.writeTimestamp(value);
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String msg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + msg + ", expecting field name");
        }
    }

    public void writeEndArray() throws IOException {
        this._writeContext = this._writeContext.getParent();
        this._writer.stepOut();
    }

    public void writeEndObject() throws IOException {
        this._writeContext = this._writeContext.getParent();
        this._writer.stepOut();
    }

    public void writeEndSexp() throws IOException {
        this._writeContext = this._writeContext.getParent();
        this._writer.stepOut();
    }

    public void writeFieldName(String value) throws IOException {
        int status = this._writeContext.writeFieldName(value);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(value);
    }

    protected void _writeFieldName(String value) throws IOException {
        this._writer.setFieldName(value);
    }

    public void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writer.stepIn(IonType.LIST);
    }

    public void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writer.stepIn(IonType.STRUCT);
    }

    public void writeStartSexp() throws IOException {
        this._verifyValueWrite("start a sexp");
        this._writeContext = ((IonWriteContext)this._writeContext).createChildSexpContext();
        this._writer.stepIn(IonType.SEXP);
    }

    public void writeTypeId(Object rawId) throws IOException {
        if (rawId instanceof String[]) {
            String[] ids;
            for (String id : ids = (String[])rawId) {
                this.annotateNextValue(id);
            }
        } else {
            this.annotateNextValue(String.valueOf(rawId));
        }
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + ", Ion writer: " + this._writer + "]";
    }

    protected void _reportNoRaw() throws IOException {
        throw new IOException("writeRaw() functionality not available with Ion backend");
    }

    public static enum Feature implements FormatFeature
    {
        USE_NATIVE_TYPE_ID(true);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

