/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jakarta.rs.cbor;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.jakarta.rs.base.ProviderBase;
import com.fasterxml.jackson.jakarta.rs.cbor.CBOREndpointConfig;
import com.fasterxml.jackson.jakarta.rs.cbor.CBORMapperConfigurator;
import com.fasterxml.jackson.jakarta.rs.cbor.CBORMediaTypes;
import com.fasterxml.jackson.jakarta.rs.cbor.PackageVersion;
import com.fasterxml.jackson.jakarta.rs.cfg.Annotations;
import com.fasterxml.jackson.jakarta.rs.cfg.MapperConfiguratorBase;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/cbor", "*/*"})
public class JacksonCBORProvider
extends ProviderBase<JacksonCBORProvider, ObjectMapper, CBOREndpointConfig, CBORMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonCBORProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonCBORProvider(Annotations ... annotationsToUse) {
        this((ObjectMapper)null, annotationsToUse);
    }

    public JacksonCBORProvider(ObjectMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonCBORProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
        super((MapperConfiguratorBase)new CBORMapperConfigurator(mapper, annotationsToUse));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return CBORMediaTypes.APPLICATION_JACKSON_CBOR_TYPE.getSubtype().equalsIgnoreCase(subtype) || "cbor".equalsIgnoreCase(subtype) || subtype.endsWith("+cbor");
        }
        return true;
    }

    protected ObjectMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        if (this._providers != null) {
            ObjectMapper mapper;
            ContextResolver resolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
            if (resolver == null) {
                resolver = this._providers.getContextResolver(ObjectMapper.class, null);
            }
            if (resolver != null && (mapper = (ObjectMapper)resolver.getContext(type)).getFactory() instanceof CBORFactory) {
                return mapper;
            }
        }
        return null;
    }

    protected CBOREndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return CBOREndpointConfig.forReading(reader, annotations);
    }

    protected CBOREndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return CBOREndpointConfig.forWriting(writer, annotations);
    }
}

