/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree.util;

import com.fasterxml.jackson.jr.private_.Base64Variant;
import com.fasterxml.jackson.jr.private_.JsonLocation;
import com.fasterxml.jackson.jr.private_.JsonParseException;
import com.fasterxml.jackson.jr.private_.JsonParser;
import com.fasterxml.jackson.jr.private_.JsonStreamContext;
import com.fasterxml.jackson.jr.private_.JsonToken;
import com.fasterxml.jackson.jr.private_.ObjectCodec;
import com.fasterxml.jackson.jr.private_.Version;
import com.fasterxml.jackson.jr.private_.base.ParserMinimalBase;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsValue;
import com.fasterxml.jackson.jr.stree.PackageVersion;
import com.fasterxml.jackson.jr.stree.util.JrsValueCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JrsTreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected JrsValueCursor _nodeCursor;
    protected JsonToken _nextToken;
    protected boolean _startContainer;
    protected boolean _closed;

    public JrsTreeTraversingParser(JrsValue jrsValue) {
        this(jrsValue, null);
    }

    public JrsTreeTraversingParser(JrsValue jrsValue, ObjectCodec objectCodec) {
        super(0);
        this._objectCodec = objectCodec;
        if (jrsValue.isArray()) {
            this._nextToken = JsonToken.START_ARRAY;
            this._nodeCursor = new JrsValueCursor.ArrayCursor((JrsArray)jrsValue, null);
        } else if (jrsValue.isObject()) {
            this._nextToken = JsonToken.START_OBJECT;
            this._nodeCursor = new JrsValueCursor.ObjectCursor((JrsObject)jrsValue, null);
        } else {
            this._nodeCursor = new JrsValueCursor.RootCursor(jrsValue, null);
        }
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        if (this._nextToken != null) {
            this._currToken = this._nextToken;
            this._nextToken = null;
            return this._currToken;
        }
        if (this._startContainer) {
            this._startContainer = false;
            if (!this._nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this._nodeCursor = this._nodeCursor.iterateChildren();
            this._currToken = this._nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        if (this._nodeCursor == null) {
            this._closed = true;
            return null;
        }
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken != null) {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this._nodeCursor.endToken();
        this._nodeCursor = this._nodeCursor.getParent();
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String currentName() {
        return this._nodeCursor == null ? null : this._nodeCursor.getCurrentName();
    }

    @Override
    @Deprecated
    public String getCurrentName() {
        return this.currentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        if (this._nodeCursor != null) {
            this._nodeCursor.overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    @Deprecated
    public JsonLocation getTokenLocation() {
        return this.currentTokenLocation();
    }

    @Override
    public JsonLocation currentLocation() {
        return JsonLocation.NA;
    }

    @Override
    @Deprecated
    public JsonLocation getCurrentLocation() {
        return this.currentLocation();
    }

    @Override
    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this.currentNode().asText();
            }
        }
        return this._currToken == null ? null : this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        JrsNumber jrsNumber = this.currentNumericNode();
        return jrsNumber == null ? null : ((JrsValue)jrsNumber).numberType();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumericNode().asBigInteger();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumericNode().asBigDecimal();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.currentNumericValue().doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return (float)this.currentNumericValue().doubleValue();
    }

    @Override
    public long getLongValue() throws IOException {
        return this.currentNumericValue().longValue();
    }

    @Override
    public int getIntValue() throws IOException {
        return this.currentNumericValue().intValue();
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.currentNumericValue();
    }

    @Override
    public Object getEmbeddedObject() {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        return -1;
    }

    protected JrsValue currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JrsNumber currentNumericNode() throws JsonParseException {
        JrsValue jrsValue = this.currentNode();
        if (jrsValue == null || !(jrsValue instanceof JrsNumber)) {
            JsonToken jsonToken = jrsValue == null ? null : jrsValue.asToken();
            throw this._constructError("Current token (" + (Object)((Object)jsonToken) + ") not numeric, can not use numeric value accessors");
        }
        return (JrsNumber)jrsValue;
    }

    protected Number currentNumericValue() throws JsonParseException {
        return this.currentNumericNode().getValue();
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

