/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.androidrecord;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AndroidRecordModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addValueInstantiators(AndroidRecordModule::findValueInstantiator);
        context.setClassIntrospector((ClassIntrospector)new AndroidRecordClassIntrospector());
    }

    static boolean isDesugaredRecordClass(Class<?> raw) {
        return raw.getSuperclass() != null && raw.getSuperclass().getName().equals("com.android.tools.r8.RecordTag");
    }

    private static ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
        Class raw = beanDesc.getType().getRawClass();
        if (!defaultInstantiator.canCreateFromObjectWith() && defaultInstantiator instanceof StdValueInstantiator && AndroidRecordModule.isDesugaredRecordClass(raw)) {
            Map<String, Type> components = AndroidRecordModule.getDesugaredRecordComponents(raw).collect(Collectors.toMap(Field::getName, Field::getGenericType));
            boolean found = false;
            for (AnnotatedConstructor constructor : beanDesc.getConstructors()) {
                Parameter[] parameters = constructor.getAnnotated().getParameters();
                Map<String, Type> parameterTypes = Arrays.stream(parameters).collect(Collectors.toMap(Parameter::getName, Parameter::getParameterizedType));
                if (!parameterTypes.equals(components)) continue;
                if (found) {
                    throw new IllegalArgumentException(String.format("Multiple constructors match set of components for record %s", raw.getName()));
                }
                AnnotationIntrospector intro = config.getAnnotationIntrospector();
                SettableBeanProperty[] properties = new SettableBeanProperty[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    AnnotatedParameter parameter = constructor.getParameter(i);
                    JacksonInject.Value injectable = intro.findInjectableValue((AnnotatedMember)parameter);
                    PropertyName name = intro.findNameForDeserialization((Annotated)parameter);
                    if (name == null || name.isEmpty()) {
                        name = PropertyName.construct((String)parameters[i].getName());
                    }
                    properties[i] = CreatorProperty.construct((PropertyName)name, (JavaType)parameter.getType(), null, null, (Annotations)parameter.getAllAnnotations(), (AnnotatedParameter)parameter, (int)i, (JacksonInject.Value)injectable, null);
                }
                ((StdValueInstantiator)defaultInstantiator).configureFromObjectSettings(null, null, null, null, (AnnotatedWithParams)constructor, properties);
                ClassUtil.checkAndFixAccess((Member)constructor.getAnnotated(), (boolean)false);
                found = true;
            }
        }
        return defaultInstantiator;
    }

    private static Stream<Field> getDesugaredRecordComponents(Class<?> raw) {
        return Arrays.stream(raw.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers()));
    }

    private static class AndroidRecordClassIntrospector
    extends BasicClassIntrospector {
        private AndroidRecordClassIntrospector() {
        }

        protected POJOPropertiesCollector collectProperties(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r, boolean forSerialization) {
            if (AndroidRecordModule.isDesugaredRecordClass(type.getRawClass())) {
                AnnotatedClass classDef = this._resolveAnnotatedClass(config, type, r);
                AndroidRecordNaming accNaming = new AndroidRecordNaming(config, classDef);
                return this.constructPropertyCollector(config, classDef, type, forSerialization, (AccessorNamingStrategy)accNaming);
            }
            return super.collectProperties(config, type, r, forSerialization);
        }
    }

    private static final class AndroidRecordNaming
    extends DefaultAccessorNamingStrategy {
        private final Set<String> _componentNames;

        private AndroidRecordNaming(MapperConfig<?> config, AnnotatedClass forClass) {
            super(config, forClass, null, "get", "is", null);
            this._componentNames = AndroidRecordModule.getDesugaredRecordComponents(forClass.getRawType()).map(Field::getName).collect(Collectors.toSet());
        }

        public String findNameForRegularGetter(AnnotatedMethod am, String name) {
            if (this._componentNames.contains(name)) {
                return name;
            }
            return super.findNameForRegularGetter(am, name);
        }
    }
}

