/*******************************************************************************
* Copyright 2018 Ivan Shubin http://galenframework.com
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*   http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
******************************************************************************/
package com.galenframework.suite.reader;

import java.util.HashMap;
import java.util.Map;

public class Context {
    
    private Map<String, Object> parameters = new HashMap<>();

    public Context withParameter(String name, Object value) {
        getParameters().put(name, value);
        return this;
    }

    public Object getValue(String paramName) {
        return getParameters().get(paramName);
    }
    
    public void putValue(String name, Object value) {
        getParameters().put(name, value);
    }

    public boolean containsValue(String paramName) {
        return getParameters().containsKey(paramName);
    }

    
    public void addValuesFromMap(Map<String, String> map) {
        getParameters().putAll(map);
    }

    public Map<String, Object> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}
