/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionVersion;
import com.galenframework.config.GalenConfig;
import com.galenframework.runner.CombinedListener;
import com.galenframework.runner.CompleteListener;
import com.galenframework.validation.FailureListener;
import java.io.PrintStream;
import org.apache.commons.lang3.ArrayUtils;

public class GalenMain {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private CompleteListener listener;

    public GalenMain() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public GalenMain(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public void execute(String ... arguments) {
        FailureListener failureListener = new FailureListener();
        CombinedListener combinedListener = new CombinedListener();
        combinedListener.add(failureListener);
        if (this.listener != null) {
            combinedListener.add(this.listener);
        }
        if (arguments.length > 0) {
            String actionName = arguments[0];
            String[] actionArguments = (String[])ArrayUtils.subarray((Object[])arguments, (int)1, (int)arguments.length);
            GalenAction action = GalenAction.create(actionName, actionArguments, this.outStream, this.errStream, combinedListener);
            try {
                action.execute();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            new GalenActionVersion(arguments, this.outStream, this.errStream).execute();
        }
        combinedListener.done();
        if (GalenConfig.getConfig().getUseFailExitCode() && failureListener.hasFailures()) {
            this.errStream.println("There were failures in galen tests");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new GalenMain().execute(args);
    }

    public CompleteListener getListener() {
        return this.listener;
    }

    public void setListener(CompleteListener listener) {
        this.listener = listener;
    }
}

