/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework;

import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestReport;
import com.galenframework.runner.CompleteListener;
import com.galenframework.runner.EventHandler;
import com.galenframework.runner.TestListener;
import com.galenframework.runner.events.TestRetryEvent;
import com.galenframework.tests.GalenTest;
import com.galenframework.tests.TestSession;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunnable.class);
    private final GalenTest test;
    private final CompleteListener listener;
    private final EventHandler eventHandler;
    private final List<GalenTestInfo> testInfos;

    public TestRunnable(GalenTest test, CompleteListener listener, EventHandler eventHandler, List<GalenTestInfo> testInfos) {
        this.test = test;
        this.listener = listener;
        this.eventHandler = eventHandler;
        this.testInfos = testInfos;
    }

    private GalenTestInfo runTest() {
        GalenTestInfo info;
        block2: {
            info = new GalenTestInfo(this.test.getName(), this.test);
            TestReport report = new TestReport();
            info.setStartedAt(new Date());
            info.setReport(report);
            TestSession session = TestSession.register(info);
            session.setReport(report);
            session.setListener(this.listener);
            this.eventHandler.invokeBeforeTestEvents(info);
            this.tellTestStarted(this.listener, this.test);
            try {
                this.test.execute(report, this.listener);
            }
            catch (Exception ex) {
                info.setException(ex);
                report.error(ex);
                if (this.listener == null) break block2;
                this.listener.onGlobalError(ex);
            }
        }
        info.setEndedAt(new Date());
        this.eventHandler.invokeAfterTestEvents(info);
        this.tellTestFinished(this.listener, this.test);
        TestSession.clear();
        return info;
    }

    @Override
    public void run() {
        GalenTestInfo info = null;
        boolean shouldRetry = true;
        int tries = 1;
        while (shouldRetry) {
            info = this.runTest();
            shouldRetry = info.isFailed() ? this.checkIfShouldRetry(info.getTest(), tries) : false;
            ++tries;
        }
        this.testInfos.add(info);
    }

    private boolean checkIfShouldRetry(GalenTest test, int tries) {
        for (TestRetryEvent retryEvent : this.eventHandler.getTestRetryEvents()) {
            if (!retryEvent.shouldRetry(test, tries)) continue;
            return true;
        }
        return false;
    }

    private void tellTestFinished(TestListener testListener, GalenTest test) {
        try {
            if (testListener != null) {
                testListener.onTestFinished(test);
            }
        }
        catch (Exception e) {
            LOG.error("Unkown error during test finishing", (Throwable)e);
        }
    }

    private void tellTestStarted(TestListener testListener, GalenTest test) {
        try {
            if (testListener != null) {
                testListener.onTestStarted(test);
            }
        }
        catch (Exception e) {
            LOG.error("Unkown error during test start", (Throwable)e);
        }
    }
}

