/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenActionDumpArguments {
    private List<String> paths;
    private Integer maxWidth;
    private Integer maxHeight;
    private String export;
    private Dimension screenSize;
    private String url;
    private String config;

    public static GalenActionDumpArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("u", "url", true, "Initial test url");
        options.addOption("s", "size", true, "Browser window size");
        options.addOption("W", "max-width", true, "Maximum width of element area image");
        options.addOption("H", "max-height", true, "Maximum height of element area image");
        options.addOption("E", "export", true, "Export path for page dump");
        options.addOption("c", "config", true, "Path to config");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionDumpArguments arguments = new GalenActionDumpArguments();
        arguments.setUrl(cmd.getOptionValue("u"));
        arguments.setScreenSize(GalenActionDumpArguments.convertScreenSize(cmd.getOptionValue("s")));
        arguments.setMaxWidth(GalenActionDumpArguments.parseOptionalInt(cmd.getOptionValue("W")));
        arguments.setMaxHeight(GalenActionDumpArguments.parseOptionalInt(cmd.getOptionValue("H")));
        arguments.setExport(cmd.getOptionValue("E"));
        arguments.setPaths(Arrays.asList(cmd.getArgs()));
        arguments.setConfig(cmd.getOptionValue("c"));
        return arguments;
    }

    private static Integer parseOptionalInt(String valueText) {
        if (valueText != null && !valueText.trim().isEmpty()) {
            return Integer.parseInt(valueText);
        }
        return null;
    }

    private static Dimension convertScreenSize(String text) {
        String[] values;
        if (text == null) {
            return null;
        }
        if (Pattern.matches("[0-9]+x[0-9]+", text) && (values = text.split("x")).length == 2) {
            return new Dimension(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
        }
        throw new IllegalArgumentException("Incorrect size: " + text);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public GalenActionDumpArguments setPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }

    public GalenActionDumpArguments setScreenSize(Dimension screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public GalenActionDumpArguments setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public GalenActionDumpArguments setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public String getExport() {
        return this.export;
    }

    public GalenActionDumpArguments setExport(String export) {
        this.export = export;
        return this;
    }

    public GalenActionDumpArguments setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.paths).append((Object)this.maxWidth).append((Object)this.maxHeight).append((Object)this.export).append((Object)this.screenSize).append((Object)this.url).append((Object)this.config).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenActionDumpArguments)) {
            return false;
        }
        GalenActionDumpArguments rhs = (GalenActionDumpArguments)obj;
        return new EqualsBuilder().append(rhs.paths, this.paths).append((Object)rhs.maxWidth, (Object)this.maxWidth).append((Object)rhs.maxHeight, (Object)this.maxHeight).append((Object)rhs.export, (Object)this.export).append((Object)rhs.screenSize, (Object)this.screenSize).append((Object)rhs.url, (Object)this.url).append((Object)rhs.config, (Object)this.config).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("paths", this.paths).append("maxWidth", (Object)this.maxWidth).append("maxHeight", (Object)this.maxHeight).append("export", (Object)this.export).append("screenSize", (Object)this.screenSize).append("url", (Object)this.url).append("config", (Object)this.config).toString();
    }

    public GalenActionDumpArguments setConfig(String config) {
        this.config = config;
        return this;
    }

    public String getConfig() {
        return this.config;
    }
}

