/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenActionGenerateArguments {
    private String path;
    private String export;
    private boolean useGalenExtras = true;

    public static GalenActionGenerateArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("e", "export", true, "Path to generated spec file");
        options.addOption("G", "no-galen-extras", false, "Disable galen-extras expressions");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionGenerateArguments arguments = new GalenActionGenerateArguments();
        arguments.setExport(cmd.getOptionValue("e"));
        arguments.setUseGalenExtras(!cmd.hasOption("G"));
        if (cmd.getArgs() == null || cmd.getArgs().length < 1) {
            throw new IllegalArgumentException("Missing page dump file");
        }
        arguments.setPath(cmd.getArgs()[0]);
        return arguments;
    }

    public String getExport() {
        return this.export;
    }

    public GalenActionGenerateArguments setExport(String export) {
        this.export = export;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public GalenActionGenerateArguments setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GalenActionGenerateArguments that = (GalenActionGenerateArguments)o;
        return new EqualsBuilder().append(this.useGalenExtras, that.useGalenExtras).append((Object)this.path, (Object)that.path).append((Object)this.export, (Object)that.export).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.path).append((Object)this.export).append(this.useGalenExtras).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("path", (Object)this.path).append("export", (Object)this.export).append("useGalenExtras", this.useGalenExtras).toString();
    }

    public boolean isUseGalenExtras() {
        return this.useGalenExtras;
    }

    public GalenActionGenerateArguments setUseGalenExtras(boolean useGalenExtras) {
        this.useGalenExtras = useGalenExtras;
        return this;
    }
}

