/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionMutateArguments;
import com.galenframework.actions.GalenActionTest;
import com.galenframework.actions.GalenActionTestArguments;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.runner.CombinedListener;
import com.galenframework.runner.EventHandler;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.suite.actions.GalenPageActionMutate;
import com.galenframework.tests.GalenBasicTest;
import com.galenframework.tests.GalenTest;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;

public class GalenActionMutate
extends GalenAction {
    private final CombinedListener listener;
    private final GalenActionMutateArguments mutateArguments;

    public GalenActionMutate(String[] arguments, PrintStream outStream, PrintStream errStream, CombinedListener listener) {
        super(arguments, outStream, errStream);
        this.mutateArguments = GalenActionMutateArguments.parse(arguments);
        this.listener = this.createListeners(listener);
    }

    @Override
    public void execute() throws IOException {
        this.verifyArguments();
        this.loadConfigIfNeeded(this.mutateArguments.getConfig());
        LinkedList<GalenTest> galenTests = new LinkedList<GalenTest>();
        for (String pageSpecPath : this.mutateArguments.getPaths()) {
            GalenBasicTest test = new GalenBasicTest();
            test.setName(pageSpecPath);
            test.setPageTests(Arrays.asList(new GalenPageTest().withTitle("Mutation test").withUrl(this.mutateArguments.getUrl()).withSize(this.mutateArguments.getScreenSize()).withBrowserFactory(new SeleniumBrowserFactory()).withActions(Arrays.asList(new GalenPageActionMutate().withSpec(pageSpecPath).withIncludedTags(this.mutateArguments.getIncludedTags()).withExcludedTags(this.mutateArguments.getExcludedTags()).withMutationOptions(this.mutateArguments.getMutationOptions()).withOriginalCommand(this.originalCommand(this.arguments))))));
            galenTests.add(test);
        }
        GalenActionTestArguments testArguments = new GalenActionTestArguments();
        testArguments.setHtmlReport(this.mutateArguments.getHtmlReport());
        testArguments.setJsonReport(this.mutateArguments.getJsonReport());
        testArguments.setJunitReport(this.mutateArguments.getJunitReport());
        testArguments.setTestngReport(this.mutateArguments.getTestngReport());
        GalenActionTest.runTests(new EventHandler(), galenTests, testArguments, this.listener);
    }

    public GalenActionMutateArguments getMutateArguments() {
        return this.mutateArguments;
    }

    private void verifyArguments() {
        if (this.mutateArguments.getUrl() == null) {
            throw new IllegalArgumentException("Url is not specified");
        }
        if (this.mutateArguments.getScreenSize() == null) {
            throw new IllegalArgumentException("Screen size is not specified");
        }
        if (this.mutateArguments.getPaths().size() < 1) {
            throw new IllegalArgumentException("There are no specs specified");
        }
    }
}

