/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.TestRunnable;
import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionTestArguments;
import com.galenframework.config.GalenConfig;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.HtmlReportBuilder;
import com.galenframework.reports.JunitReportBuilder;
import com.galenframework.reports.TestNgReportBuilder;
import com.galenframework.reports.json.JsonReportBuilder;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.runner.CombinedListener;
import com.galenframework.runner.CompleteListener;
import com.galenframework.runner.EventHandler;
import com.galenframework.runner.JsTestCollector;
import com.galenframework.runner.events.TestFilterEvent;
import com.galenframework.suite.reader.GalenSuiteReader;
import com.galenframework.tests.GalenTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenActionTest
extends GalenAction {
    private static final Logger LOG = LoggerFactory.getLogger(GalenActionTest.class);
    private final GalenActionTestArguments testArguments;
    private final CombinedListener listener;

    public GalenActionTest(String[] arguments, PrintStream outStream, PrintStream errStream, CombinedListener listener) {
        super(arguments, outStream, errStream);
        this.testArguments = GalenActionTestArguments.parse(arguments);
        this.listener = this.createListeners(listener);
    }

    @Override
    public void execute() throws Exception {
        this.loadConfigIfNeeded(this.getTestArguments().getConfig());
        LinkedList<File> basicTestFiles = new LinkedList<File>();
        LinkedList<File> jsTestFiles = new LinkedList<File>();
        for (String path : this.testArguments.getPaths()) {
            File file = new File(path);
            if (file.exists()) {
                if (file.isDirectory()) {
                    this.searchForTests(file, this.testArguments.getRecursive(), basicTestFiles, jsTestFiles);
                    continue;
                }
                if (!file.isFile()) continue;
                String name = file.getName().toLowerCase();
                if (name.endsWith(GalenConfig.getConfig().getTestSuffix())) {
                    basicTestFiles.add(file);
                    continue;
                }
                if (!name.endsWith(".js")) continue;
                jsTestFiles.add(file);
                continue;
            }
            throw new FileNotFoundException(path);
        }
        if (basicTestFiles.size() <= 0 && jsTestFiles.size() <= 0) {
            throw new RuntimeException("Couldn't find any test files");
        }
        this.runTestFiles(basicTestFiles, jsTestFiles);
    }

    private void runTestFiles(List<File> basicTestFiles, List<File> jsTestFiles) throws IOException {
        GalenSuiteReader reader = new GalenSuiteReader();
        LinkedList<GalenTest> tests = new LinkedList<GalenTest>();
        for (File file : basicTestFiles) {
            tests.addAll(reader.read(file));
        }
        JsTestCollector testCollector = new JsTestCollector(tests);
        for (File jsFile : jsTestFiles) {
            testCollector.execute(jsFile);
        }
        testCollector.getEventHandler().invokeBeforeTestSuiteEvents();
        GalenActionTest.runTests(testCollector.getEventHandler(), tests, this.testArguments, this.listener);
        testCollector.getEventHandler().invokeAfterTestSuiteEvents();
    }

    public static void runTests(EventHandler eventHandler, List<GalenTest> tests, GalenActionTestArguments testArguments, CombinedListener listener) {
        if (testArguments.getParallelThreads() > 1) {
            GalenActionTest.runTestsInThreads(eventHandler, tests, testArguments.getParallelThreads(), testArguments, listener);
        } else {
            GalenActionTest.runTestsInThreads(eventHandler, tests, 1, testArguments, listener);
        }
    }

    private static void runTestsInThreads(EventHandler eventHandler, List<GalenTest> tests, int amountOfThreads, GalenActionTestArguments testArguments, CombinedListener listener) {
        ExecutorService executor = Executors.newFixedThreadPool(amountOfThreads);
        Pattern filterPattern = GalenActionTest.createTestFilter(testArguments.getFilter());
        List<GalenTest> filteredTests = GalenActionTest.filterTests(tests, eventHandler);
        GalenActionTest.tellBeforeTestSuite(listener, filteredTests);
        List<GalenTestInfo> testInfos = Collections.synchronizedList(new LinkedList());
        for (GalenTest test : filteredTests) {
            if (!GalenActionTest.matchesPattern(test.getName(), filterPattern) || !GalenActionTest.matchesSelectedGroups(test, testArguments.getGroups()) || !GalenActionTest.doesNotMatchExcludedGroups(test, testArguments.getExcludedGroups())) continue;
            executor.execute(new TestRunnable(test, listener, eventHandler, testInfos));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        GalenActionTest.tellAfterTestSuite(testInfos, listener);
        GalenActionTest.createAllReports(testInfos, testArguments);
        GalenActionTest.cleanData(testInfos);
    }

    private void searchForTests(File file, boolean recursive, List<File> files, List<File> jsFiles, int level) {
        block4: {
            block2: {
                String fileName;
                block3: {
                    fileName = file.getName().toLowerCase();
                    if (!file.isFile()) break block2;
                    if (!fileName.endsWith(GalenConfig.getConfig().getTestSuffix())) break block3;
                    files.add(file);
                    break block4;
                }
                if (!fileName.endsWith(GalenConfig.getConfig().getTestJsSuffix())) break block4;
                jsFiles.add(file);
                break block4;
            }
            if (file.isDirectory() && (level == 0 || recursive)) {
                for (File childFile : file.listFiles()) {
                    this.searchForTests(childFile, recursive, files, jsFiles, level + 1);
                }
            }
        }
    }

    private static void cleanData(List<GalenTestInfo> testInfos) {
        for (GalenTestInfo testInfo : testInfos) {
            FileTempStorage storage;
            if (testInfo.getReport() == null || (storage = testInfo.getReport().getFileStorage()) == null) continue;
            storage.cleanup();
        }
    }

    private static boolean doesNotMatchExcludedGroups(GalenTest test, List<String> excludedGroups) {
        if (excludedGroups != null && excludedGroups.size() > 0) {
            return !GalenActionTest.matchesSelectedGroups(test, excludedGroups);
        }
        return true;
    }

    private static boolean matchesSelectedGroups(GalenTest test, List<String> selectedGroups) {
        if (selectedGroups != null && selectedGroups.size() > 0) {
            List<String> testGroups = test.getGroups();
            if (testGroups != null && testGroups.size() > 0) {
                for (String testGroup : testGroups) {
                    if (!selectedGroups.contains(testGroup)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static List<GalenTest> filterTests(List<GalenTest> tests, EventHandler eventHandler) {
        List<TestFilterEvent> filters = eventHandler.getTestFilterEvents();
        if (filters != null && filters.size() > 0) {
            GalenTest[] arrTests = tests.toArray(new GalenTest[0]);
            for (TestFilterEvent filter : filters) {
                arrTests = filter.execute(arrTests);
            }
            if (arrTests == null) {
                arrTests = new GalenTest[]{};
            }
            return Arrays.asList(arrTests);
        }
        return tests;
    }

    private static void tellBeforeTestSuite(CompleteListener listener, List<GalenTest> tests) {
        if (listener != null) {
            try {
                listener.beforeTestSuite(tests);
            }
            catch (Exception ex) {
                LOG.error("Unknown error before running testsuites.", (Throwable)ex);
            }
        }
    }

    private static void tellAfterTestSuite(List<GalenTestInfo> testInfos, CombinedListener listener) {
        if (listener != null) {
            try {
                listener.afterTestSuite(testInfos);
            }
            catch (Exception ex) {
                LOG.error("Unknown error after running testsuites.", (Throwable)ex);
            }
        }
    }

    private static void createAllReports(List<GalenTestInfo> testInfos, GalenActionTestArguments testArguments) {
        if (testArguments.getTestngReport() != null) {
            GalenActionTest.createTestngReport(testArguments.getTestngReport(), testInfos);
        }
        if (testArguments.getJunitReport() != null) {
            GalenActionTest.createJunitReport(testArguments.getJunitReport(), testInfos);
        }
        if (testArguments.getHtmlReport() != null) {
            GalenActionTest.createHtmlReport(testArguments.getHtmlReport(), testInfos);
        }
        if (testArguments.getJsonReport() != null) {
            GalenActionTest.createJsonReport(testArguments.getJsonReport(), testInfos);
        }
    }

    private static void createJsonReport(String jsonReport, List<GalenTestInfo> testInfos) {
        try {
            new JsonReportBuilder().build(testInfos, jsonReport);
        }
        catch (IOException e) {
            LOG.error("Failed generating json report", (Throwable)e);
        }
    }

    private static void createHtmlReport(String htmlReportPath, List<GalenTestInfo> testInfos) {
        try {
            new HtmlReportBuilder().build(testInfos, htmlReportPath);
        }
        catch (Exception ex) {
            LOG.error("Unknown error during creating HTML report.", (Throwable)ex);
        }
    }

    private static void createJunitReport(String junitReport, List<GalenTestInfo> testInfos) {
        try {
            new JunitReportBuilder().build(testInfos, junitReport);
        }
        catch (Exception ex) {
            LOG.error("Unknown error during creating Junit report.", (Throwable)ex);
        }
    }

    private static void createTestngReport(String testngReport, List<GalenTestInfo> testInfos) {
        try {
            new TestNgReportBuilder().build(testInfos, testngReport);
        }
        catch (Exception ex) {
            LOG.error("Unknown error during creating TestNG report.", (Throwable)ex);
        }
    }

    private static boolean matchesPattern(String name, Pattern filterPattern) {
        if (filterPattern != null) {
            return filterPattern.matcher(name).matches();
        }
        return true;
    }

    private static Pattern createTestFilter(String filter) {
        return filter != null ? Pattern.compile(filter.replace("*", ".*")) : null;
    }

    private void searchForTests(File file, boolean recursive, List<File> files, List<File> jsFiles) {
        this.searchForTests(file, recursive, files, jsFiles, 0);
    }

    public GalenActionTestArguments getTestArguments() {
        return this.testArguments;
    }
}

