/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.browser.mutation;

import com.galenframework.browser.Browser;
import com.galenframework.browser.mutation.MutationRecordPageProxy;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import java.awt.Dimension;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class MutationRecordBrowser
implements Browser {
    private Browser originBrowser;
    private Map<String, PageElement> recordedElements = new HashMap<String, PageElement>();
    private Page cachedPage = null;

    public MutationRecordBrowser(Browser originBrowser) {
        this.originBrowser = originBrowser;
    }

    @Override
    public void quit() {
        this.originBrowser.quit();
    }

    @Override
    public void changeWindowSize(Dimension screenSize) {
        this.originBrowser.changeWindowSize(screenSize);
    }

    @Override
    public void load(String url) {
        this.originBrowser.load(url);
    }

    @Override
    public Object executeJavascript(String javascript) {
        return this.originBrowser.executeJavascript(javascript);
    }

    @Override
    public Page getPage() {
        if (this.cachedPage == null) {
            this.cachedPage = (Page)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Page.class}, (InvocationHandler)new MutationRecordPageProxy(this.originBrowser, this.recordedElements));
        }
        return this.cachedPage;
    }

    @Override
    public void refresh() {
        this.originBrowser.refresh();
    }

    @Override
    public String getUrl() {
        return this.originBrowser.getUrl();
    }

    @Override
    public Dimension getScreenSize() {
        return this.originBrowser.getScreenSize();
    }

    public Map<String, PageElement> getRecordedElements() {
        return this.recordedElements;
    }
}

