/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.galenframework.generator.PageItemNode;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class SpecGeneratorUtils {
    public static String findNamingPattern(List<String> allObjectNames, PageItemNode[] pins) {
        if (pins.length > 1) {
            HashSet<String> suffix = new HashSet<String>();
            for (PageItemNode pin : pins) {
                suffix.add(SpecGeneratorUtils.stripOffDigitAtTheEnd(pin.getPageItem().getName()));
                if (suffix.size() <= 1) continue;
                return null;
            }
            String firstPart = (String)suffix.iterator().next();
            if (SpecGeneratorUtils.verifyMatchesAllNamesExactly(allObjectNames, firstPart, pins.length)) {
                return firstPart + "*";
            }
            return null;
        }
        return null;
    }

    private static boolean verifyMatchesAllNamesExactly(List<String> allObjectNames, String firstPart, int amount) {
        Pattern pattern = Pattern.compile("\\Q" + firstPart + "\\E.*");
        int count = 0;
        for (String name : allObjectNames) {
            if (!pattern.matcher(name).matches() || ++count <= amount) continue;
            return false;
        }
        return count == amount;
    }

    private static String stripOffDigitAtTheEnd(String name) {
        for (int i = name.length() - 1; i > 0; --i) {
            char symbol = name.charAt(i);
            if (symbol >= '0' && symbol <= '9') continue;
            return name.substring(0, i + 1);
        }
        return name;
    }
}

