/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.filters.SpecFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SuggestionTestResult {
    private Map<String, List<SpecStatement>> generatedRules;
    private Map<String, List<SpecStatement>> generatedObjectSpecs;
    private List<SpecFilter> filters;

    public Map<String, List<SpecStatement>> getGeneratedObjectSpecs() {
        return this.generatedObjectSpecs;
    }

    public SuggestionTestResult setGeneratedObjectSpecs(Map<String, List<SpecStatement>> generatedObjectSpecs) {
        this.generatedObjectSpecs = generatedObjectSpecs;
        return this;
    }

    public boolean isValid() {
        return this.generatedRules != null && this.generatedRules.size() > 0 || this.generatedObjectSpecs != null && this.generatedObjectSpecs.size() > 0;
    }

    public List<SpecFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SpecFilter> filters) {
        this.filters = filters;
    }

    public SuggestionTestResult addObjectSpec(String objectName, SpecStatement spec) {
        if (this.generatedObjectSpecs == null) {
            this.generatedObjectSpecs = new HashMap<String, List<SpecStatement>>();
        }
        List<SpecStatement> existingSpecs = this.makeSureListExists(this.generatedObjectSpecs, objectName);
        existingSpecs.add(spec);
        return this;
    }

    public SuggestionTestResult addObjectSpecs(String objectName, List<SpecStatement> specs) {
        if (specs != null && specs.size() > 0) {
            if (this.generatedObjectSpecs == null) {
                this.generatedObjectSpecs = new HashMap<String, List<SpecStatement>>();
            }
            List<SpecStatement> existingSpecs = this.makeSureListExists(this.generatedObjectSpecs, objectName);
            existingSpecs.addAll(specs);
        }
        return this;
    }

    public SuggestionTestResult addFilter(SpecFilter filter) {
        if (this.filters == null) {
            this.filters = new LinkedList<SpecFilter>();
        }
        this.filters.add(filter);
        return this;
    }

    public void merge(SuggestionTestResult result) {
        if (result != null) {
            if (this.generatedObjectSpecs == null) {
                this.generatedObjectSpecs = new HashMap<String, List<SpecStatement>>();
            }
            this.mergeMapList(this.generatedObjectSpecs, result.getGeneratedObjectSpecs());
            if (this.generatedRules == null) {
                this.generatedRules = new HashMap<String, List<SpecStatement>>();
            }
            this.mergeMapList(this.generatedRules, result.generatedRules);
        }
    }

    private void mergeMapList(Map<String, List<SpecStatement>> origin, Map<String, List<SpecStatement>> other) {
        if (other != null) {
            other.forEach((name, otherList) -> {
                List<SpecStatement> originList = this.makeSureListExists(origin, (String)name);
                originList.addAll((Collection<SpecStatement>)otherList);
            });
        }
    }

    private List<SpecStatement> makeSureListExists(Map<String, List<SpecStatement>> origin, String name) {
        List<SpecStatement> originList = origin.get(name);
        if (originList == null) {
            originList = new LinkedList<SpecStatement>();
            origin.put(name, originList);
        }
        return originList;
    }

    public Map<String, List<SpecStatement>> getGeneratedRules() {
        return this.generatedRules;
    }

    public SuggestionTestResult setGeneratedRules(Map<String, List<SpecStatement>> generatedRules) {
        this.generatedRules = generatedRules;
        return this;
    }

    public SuggestionTestResult addGeneratedRule(String parentName, SpecStatement rule) {
        if (this.generatedRules == null) {
            this.generatedRules = new HashMap<String, List<SpecStatement>>();
        }
        List<SpecStatement> list = this.makeSureListExists(this.generatedRules, parentName);
        list.add(rule);
        return this;
    }
}

