/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.builders.SBIEdgeResult;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.builders.TriFunction;
import com.galenframework.page.Point;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

enum SBIEdge {
    TOP(0, (parent, points, options) -> {
        String validation;
        int distance = points[0].getTop() - parent.getPageItem().getArea().getTop();
        Boolean isRedundant = false;
        if (distance > options.getMinimalStickyParentDistance()) {
            if (parent.getMinimalPaddingTop() >= 0 && parent.getMinimalPaddingTop() <= options.getMinimalStickyParentDistance()) {
                validation = ">= " + parent.getMinimalPaddingTop() + "px";
            } else {
                validation = ">= 0px";
                isRedundant = true;
            }
        } else {
            validation = distance + "px";
        }
        return new SBIEdgeResult(validation, "top", new AssertionEdge(parent.getPageItem().getName(), AssertionEdge.EdgeType.top), isRedundant);
    }),
    LEFT(1, (parent, points, options) -> {
        String validation;
        int distance = points[0].getLeft() - parent.getPageItem().getArea().getLeft();
        Boolean isRedundant = false;
        if (distance > options.getMinimalStickyParentDistance()) {
            if (parent.getMinimalPaddingLeft() >= 0 && parent.getMinimalPaddingLeft() <= options.getMinimalStickyParentDistance()) {
                validation = ">= " + parent.getMinimalPaddingLeft() + "px";
            } else {
                validation = ">= 0px";
                isRedundant = true;
            }
        } else {
            validation = distance + "px";
        }
        return new SBIEdgeResult(validation, "left", new AssertionEdge(parent.getPageItem().getName(), AssertionEdge.EdgeType.left), isRedundant);
    }),
    RIGHT(2, (parent, points, options) -> {
        String validation;
        int distance = parent.getPageItem().getArea().getRight() - points[1].getLeft();
        Boolean isRedundant = false;
        if (distance > options.getMinimalStickyParentDistance()) {
            if (parent.getMinimalPaddingRight() >= 0 && parent.getMinimalPaddingRight() <= options.getMinimalStickyParentDistance()) {
                validation = ">= " + parent.getMinimalPaddingRight() + "px";
            } else {
                validation = ">= 0px";
                isRedundant = true;
            }
        } else {
            validation = distance + "px";
        }
        return new SBIEdgeResult(validation, "right", new AssertionEdge(parent.getPageItem().getName(), AssertionEdge.EdgeType.right), isRedundant);
    }),
    BOTTOM(3, (parent, points, options) -> {
        String validation;
        int distance = parent.getPageItem().getArea().getBottom() - points[3].getTop();
        Boolean isRedundant = false;
        if (distance > options.getMinimalStickyParentDistance()) {
            if (parent.getMinimalPaddingBottom() >= 0 && parent.getMinimalPaddingBottom() <= options.getMinimalStickyParentDistance()) {
                validation = ">= " + parent.getMinimalPaddingBottom() + "px";
            } else {
                validation = ">= 0px";
                isRedundant = true;
            }
        } else {
            validation = distance + "px";
        }
        return new SBIEdgeResult(validation, "bottom", new AssertionEdge(parent.getPageItem().getName(), AssertionEdge.EdgeType.bottom), isRedundant);
    });

    public final int order;
    private final TriFunction<PageItemNode, Point[], SpecGeneratorOptions, SBIEdgeResult> distanceFunc;

    private static Pair<String, AssertionEdge> pair(String specText, AssertionEdge assertionEdge) {
        return new ImmutablePair((Object)specText, (Object)assertionEdge);
    }

    private SBIEdge(int order, TriFunction<PageItemNode, Point[], SpecGeneratorOptions, SBIEdgeResult> distanceFunc) {
        this.order = order;
        this.distanceFunc = distanceFunc;
    }

    public SBIEdgeResult build(PageItemNode parent, Point[] points, SpecGeneratorOptions options) {
        return this.distanceFunc.apply(parent, points, options);
    }
}

