/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItem;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.builders.AbstractSpecBuilder;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.generator.raycast.EdgesContainer;
import java.util.Collections;
import java.util.List;

public class SpecBuilderRightOf
extends AbstractSpecBuilder {
    public static final String S_RIGHT_OF = "s_right_of";
    private final EdgesContainer.Edge leftEdge;
    private final PageItem pageItem;

    public SpecBuilderRightOf(PageItem pageItem, EdgesContainer.Edge leftEdge) {
        this.pageItem = pageItem;
        this.leftEdge = leftEdge;
    }

    @Override
    public List<SpecStatement> buildSpecs(List<SpecFilter> excludedFilters, SpecGeneratorOptions options) {
        StringBuilder s = new StringBuilder("right-of ");
        s.append(this.leftEdge.itemNode.getPageItem().getName());
        int distance = this.pageItem.getArea().getLeft() - this.leftEdge.p1.getLeft();
        if (distance <= options.getMinimalStickyHorizontalDistance()) {
            s.append(' ').append(distance).append("px");
        }
        this.extendSpecFilters(excludedFilters, "s_left_of");
        return Collections.singletonList(new SpecStatement(s.toString(), Collections.singletonList(new SpecAssertion(AssertionEdge.left(this.pageItem.getName()), AssertionEdge.right(this.leftEdge)))));
    }

    @Override
    public String getName() {
        return S_RIGHT_OF;
    }

    @Override
    public String[] getArgs() {
        return new String[]{this.pageItem.getName(), this.leftEdge.itemNode.getPageItem().getName()};
    }
}

