/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.suggestions;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.SuggestionOptions;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.suggestions.SingleArgSpecSuggestion;
import com.galenframework.page.Rect;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public class SizeSpecSuggestion
extends SingleArgSpecSuggestion {
    public static final String S_SIZE = "s_size";

    @Override
    public String getName() {
        return S_SIZE;
    }

    @Override
    protected SuggestionTestResult testIt(SuggestionOptions options, SpecGeneratorOptions specGeneratorOptions, PageItemNode pin) {
        String itemName = pin.getPageItem().getName();
        Rect area = pin.getPageItem().getArea();
        if (area.getWidth() == area.getHeight() && area.getWidth() <= 200 && specGeneratorOptions.isUseGalenExtras()) {
            return new SuggestionTestResult().addGeneratedRule(itemName, new SpecStatement(String.format("| %s should be squared with %dpx size", pin.getPageItem().getName(), area.getWidth()), Arrays.asList(new SpecAssertion(AssertionEdge.left(itemName), AssertionEdge.right(itemName)), new SpecAssertion(AssertionEdge.top(itemName), AssertionEdge.bottom(itemName)))));
        }
        LinkedList<SpecStatement> specs = new LinkedList<SpecStatement>();
        if (area.getWidth() <= 90) {
            specs.add(new SpecStatement(String.format("width %dpx", area.getWidth()), Collections.singletonList(new SpecAssertion(AssertionEdge.left(itemName), AssertionEdge.right(itemName)))));
        }
        if (area.getHeight() <= 90) {
            specs.add(new SpecStatement(String.format("height %dpx", area.getHeight()), Collections.singletonList(new SpecAssertion(AssertionEdge.top(itemName), AssertionEdge.bottom(itemName)))));
        }
        if (specs.size() > 0) {
            return new SuggestionTestResult().addObjectSpecs(pin.getPageItem().getName(), specs);
        }
        return null;
    }
}

