/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.SyntaxException;

public class StringCharReader {
    private String text;
    private int length;
    private int cursor = 0;

    public StringCharReader(String text) {
        this.text = text;
        this.length = text.length();
    }

    public void back() {
        --this.cursor;
        if (this.cursor < 0) {
            this.cursor = 0;
        }
    }

    public boolean hasMore() {
        return this.cursor < this.length;
    }

    public void moveToTheEnd() {
        this.cursor = this.length;
    }

    public char next() {
        if (this.cursor == this.length) {
            throw new IndexOutOfBoundsException();
        }
        char symbol = this.text.charAt(this.cursor);
        ++this.cursor;
        return symbol;
    }

    public char currentSymbol() {
        if (this.cursor < this.length) {
            return this.text.charAt(this.cursor);
        }
        return this.text.charAt(this.length - 1);
    }

    public String takeTheRest() {
        if (this.cursor < this.length) {
            String theRest = this.text.substring(this.cursor);
            this.cursor = this.length;
            return theRest;
        }
        return "";
    }

    public String getTheRest() {
        if (this.cursor < this.length) {
            return this.text.substring(this.cursor);
        }
        return "";
    }

    public char firstNonWhiteSpaceSymbol() {
        for (int i = this.cursor; i < this.length; ++i) {
            char symbol = this.text.charAt(i);
            if (symbol == ' ' || symbol == '\t') continue;
            return symbol;
        }
        return '\u0000';
    }

    public String readUntilSymbol(char breakingSymbol) {
        return this.readUntilSymbol(breakingSymbol, true);
    }

    public String readSafeUntilSymbol(char breakingSymbol) {
        return this.readUntilSymbol(breakingSymbol, false);
    }

    private String readUntilSymbol(char breakingSymbol, boolean failIfSymbolNotFound) {
        StringBuilder builder = new StringBuilder();
        while (this.hasMore()) {
            char ch = this.next();
            if (ch == breakingSymbol) {
                return builder.toString();
            }
            builder.append(ch);
        }
        if (failIfSymbolNotFound) {
            throw new SyntaxException("Missing symbol: " + breakingSymbol);
        }
        return builder.toString();
    }

    public boolean hasMoreNormalSymbols() {
        return this.firstNonWhiteSpaceSymbol() != '\u0000';
    }

    public String readWord() {
        return Expectations.word().read(this);
    }

    public int currentCursorPosition() {
        return this.cursor;
    }

    public void moveCursorTo(int position) {
        this.cursor = position;
    }

    public void skipWord() {
        this.readWord();
    }
}

