/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.galenframework.reports.GalenTestAggregatedInfo;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestIdGenerator;
import com.galenframework.utils.GalenUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class JunitReportBuilder {
    private Configuration freemarkerConfiguration = new Configuration();
    private TestIdGenerator testIdGenerator = new TestIdGenerator();

    public void build(List<GalenTestInfo> tests, String reportPath) throws IOException, TemplateException {
        LinkedList<GalenTestAggregatedInfo> aggregatedTests = new LinkedList<GalenTestAggregatedInfo>();
        for (GalenTestInfo test : tests) {
            GalenTestAggregatedInfo aggregatedInfo = new GalenTestAggregatedInfo(this.testIdGenerator.generateTestId(test.getName()), test);
            aggregatedTests.add(aggregatedInfo);
        }
        this.exportJunitReport(aggregatedTests, reportPath);
    }

    private void exportJunitReport(List<GalenTestAggregatedInfo> tests, String reportPath) throws IOException, TemplateException {
        File file = new File(reportPath);
        this.makeSureParentPathExists(file);
        file.createNewFile();
        FileWriter fileWriter = new FileWriter(file);
        HashMap<String, List<GalenTestAggregatedInfo>> model = new HashMap<String, List<GalenTestAggregatedInfo>>();
        model.put("tests", tests);
        Template template = new Template("report-main", (Reader)new InputStreamReader(this.getClass().getResourceAsStream("/junit-report/junit-report.ftl.xml")), this.freemarkerConfiguration);
        template.process(model, (Writer)fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    private void makeSureParentPathExists(File file) throws IOException {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            GalenUtils.makeSureFolderExists(parentDir);
        }
    }
}

