/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.galenframework.reports.LayoutReportStack;
import com.galenframework.reports.model.LayoutImageComparison;
import com.galenframework.reports.model.LayoutObject;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.reports.model.LayoutSection;
import com.galenframework.reports.model.LayoutSpec;
import com.galenframework.reports.model.LayoutSpecGroup;
import com.galenframework.reports.nodes.TestReportNode;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.validation.ImageComparison;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class LayoutReportListener
implements ValidationListener {
    private Stack<LayoutReportStack> reportStack = new Stack();
    private LayoutReport rootLayoutReport;

    public LayoutReportListener(LayoutReport layoutReport) {
        this.rootLayoutReport = layoutReport;
        this.reportStack.push(new LayoutReportStack(layoutReport));
    }

    @Override
    public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        this.currentReport().pushSection(pageSection);
    }

    @Override
    public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
        this.currentReport().popSection();
    }

    @Override
    public void onSubLayout(PageValidation pageValidation, String objectName) {
        LayoutReport subLayout = new LayoutReport();
        this.currentReport().getCurrentSpec().setSubLayout(subLayout);
        this.reportStack.push(new LayoutReportStack(subLayout));
    }

    @Override
    public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
        this.reportStack.pop();
    }

    @Override
    public void onObject(PageValidation pageValidation, String objectName) {
        LayoutObject object = this.currentSection().findObject(objectName);
        if (object == null) {
            object = new LayoutObject();
            object.setName(objectName);
            this.currentSection().getObjects().add(object);
        }
        this.currentReport().setCurrentObject(object);
    }

    @Override
    public void onAfterObject(PageValidation pageValidation, String objectName) {
    }

    @Override
    public void onBeforeSpec(PageValidation pageValidation, String objectName, Spec originalSpec) {
        LayoutSpec spec = new LayoutSpec();
        spec.setPlace(originalSpec.getPlace());
        spec.setName(originalSpec.getOriginalText());
        if (originalSpec.getAlias() != null) {
            LayoutSpecGroup group = new LayoutSpecGroup();
            group.setName(originalSpec.getAlias());
            group.addSpec(spec);
            this.currentReport().getCurrentObject().addSpecGroup(group);
        } else {
            this.currentReport().getCurrentSpecCollector().add(spec);
        }
        this.currentReport().setCurrentSpec(spec);
    }

    @Override
    public void onSpecSuccess(PageValidation pageValidation, String objectName, Spec originalSpec, ValidationResult result) {
        LayoutSpec spec = this.currentReport().getCurrentSpec();
        this.addResultToSpec(spec, result);
    }

    @Override
    public void onSpecError(PageValidation pageValidation, String objectName, Spec originalSpec, ValidationResult result) {
        LayoutSpec spec = this.currentReport().getCurrentSpec();
        this.addResultToSpec(spec, result);
        if (originalSpec.isOnlyWarn()) {
            spec.setStatus(TestReportNode.Status.WARN);
        }
        try {
            if (result.getError().getImageComparison() != null) {
                spec.setImageComparison(this.convertImageComparison(objectName, result.getError().getImageComparison()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
        LayoutSpecGroup specGroup = new LayoutSpecGroup();
        specGroup.setName(specGroupName);
        specGroup.setSpecs(new LinkedList<LayoutSpec>());
        this.currentReport().getCurrentObject().addSpecGroup(specGroup);
        this.currentReport().setCurrentSpecCollector(specGroup.getSpecs());
    }

    @Override
    public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
        this.currentReport().setCurrentSpecCollector(this.currentReport().getCurrentObject().getSpecs());
    }

    private LayoutImageComparison convertImageComparison(String objectName, ImageComparison imageComparison) throws IOException {
        LayoutImageComparison layoutImageComparison = new LayoutImageComparison();
        layoutImageComparison.setActualImage(this.rootLayoutReport.registerFile(objectName + "-actual.png", imageComparison.getOriginalFilteredImage()));
        layoutImageComparison.setExpectedImage(this.rootLayoutReport.registerFile(objectName + "-expected.png", imageComparison.getSampleFilteredImage()));
        layoutImageComparison.setComparisonMapImage(this.rootLayoutReport.registerFile(objectName + "-map.png", imageComparison.getComparisonMap()));
        return layoutImageComparison;
    }

    private List<String> convertToObjectNames(List<ValidationObject> validationObjects) {
        LinkedList<String> names = new LinkedList<String>();
        if (validationObjects != null) {
            for (ValidationObject validationObject : validationObjects) {
                names.add(validationObject.getName());
            }
        }
        return names;
    }

    @Override
    public void onGlobalError(Exception e) {
    }

    @Override
    public void onBeforePageAction(GalenPageAction action) {
    }

    @Override
    public void onAfterPageAction(GalenPageAction action) {
    }

    private LayoutReportStack currentReport() {
        return this.reportStack.peek();
    }

    private LayoutSection currentSection() {
        return this.reportStack.peek().peekSection();
    }

    private void addResultToSpec(LayoutSpec spec, ValidationResult result) {
        this.currentReport().putObjects(result.getValidationObjects());
        spec.setHighlight(this.convertToObjectNames(result.getValidationObjects()));
        spec.setMeta(result.getMeta());
        if (result.getError() != null) {
            spec.setErrors(result.getError().getMessages());
            if (result.getError().isOnlyWarn()) {
                spec.setStatus(TestReportNode.Status.WARN);
            } else {
                spec.setStatus(TestReportNode.Status.ERROR);
            }
        }
    }
}

