/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import com.galenframework.utils.GalenUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ScriptProcessor
implements StructNodeProcessor {
    private final PageSpecHandler pageSpecHandler;

    public ScriptProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<StructNode> process(StringCharReader reader, StructNode scriptNode) throws IOException {
        String scriptPath = reader.getTheRest().trim();
        if (scriptPath.isEmpty()) {
            if (!scriptNode.hasChildNodes()) throw new SyntaxException(scriptNode, "Missing script");
            String completeScript = scriptNode.assembleAllChildNodes();
            this.pageSpecHandler.runJavaScript(completeScript);
            return Collections.emptyList();
        } else {
            String fullPath = this.pageSpecHandler.getFullPathToResource(scriptPath);
            String fileId = GalenUtils.calculateFileId(fullPath);
            if (this.pageSpecHandler.getProcessedScripts().contains(fileId)) return Collections.emptyList();
            this.pageSpecHandler.getProcessedScripts().add(fileId);
            this.pageSpecHandler.runJavaScriptFromFile(fullPath);
        }
        return Collections.emptyList();
    }
}

