/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.StructNodeProcessor;
import java.util.Collections;
import java.util.List;

public class SetVariableProcessor
implements StructNodeProcessor {
    private final PageSpecHandler pageSpecHandler;

    public SetVariableProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    @Override
    public List<StructNode> process(StringCharReader reader, StructNode structNode) {
        if (reader.hasMore()) {
            structNode.setName(reader.getTheRest());
            this.processVariableStatement(structNode);
        }
        if (structNode.getChildNodes() != null) {
            for (StructNode childNode : structNode.getChildNodes()) {
                this.processVariableStatement(this.pageSpecHandler.processExpressionsIn(childNode));
            }
        }
        return Collections.emptyList();
    }

    private void processVariableStatement(StructNode structNode) {
        StringCharReader reader = new StringCharReader(structNode.getName());
        String name = reader.readWord();
        if (name.isEmpty()) {
            throw new SyntaxException(structNode, "Missing variable name");
        }
        String value = reader.getTheRest().trim();
        this.pageSpecHandler.setGlobalVariable(name, value, structNode);
    }
}

