/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecCss;
import com.galenframework.specs.SpecText;

public class SpecCssProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        String cssPropertyName = reader.readWord();
        String validationTypeString = reader.readWord();
        if (cssPropertyName.isEmpty()) {
            throw new SyntaxException("Missing css property name");
        }
        if (validationTypeString.isEmpty()) {
            throw new SyntaxException("Missing validation type (is, contains, starts, ends, matches)");
        }
        SpecText.Type validationType = SpecText.Type.fromString(validationTypeString);
        String expectedText = Expectations.doubleQuotedText().read(reader);
        if (reader.hasMoreNormalSymbols()) {
            throw new SyntaxException("Too many arguments for spec: " + reader.getTheRest().trim());
        }
        return new SpecCss(cssPropertyName, validationType, expectedText);
    }
}

