/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecOcr;
import java.util.LinkedList;

public class SpecOcrProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        LinkedList<String> textOperations = new LinkedList<String>();
        this.verifyValidationEntity(reader);
        SpecOcr.Type textCheckType = null;
        while (textCheckType == null && reader.hasMoreNormalSymbols()) {
            String word = reader.readWord();
            if (word.isEmpty()) {
                throw new SyntaxException("Expected text check type, but got nothing");
            }
            if (SpecOcr.Type.isValid(word)) {
                textCheckType = SpecOcr.Type.fromString(word);
                continue;
            }
            textOperations.add(word);
        }
        String expectedText = Expectations.doubleQuotedText().read(reader);
        if (reader.hasMoreNormalSymbols()) {
            throw new SyntaxException("Too many arguments for spec: " + reader.getTheRest().trim());
        }
        return new SpecOcr(textCheckType, expectedText, textOperations);
    }

    private void verifyValidationEntity(StringCharReader reader) {
        String validationEntity = reader.readWord();
        if (!"text".equals(validationEntity)) {
            throw new SyntaxException(String.format("Unknown entity: %s, expected to see \"text\"", validationEntity));
        }
    }
}

