/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Location;
import com.galenframework.specs.Side;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecOn;
import java.util.LinkedList;
import java.util.List;

public class SpecOnProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        String objectName;
        Side side;
        LinkedList<String> allEdges = new LinkedList<String>();
        boolean edgesAreNotRead = true;
        while (edgesAreNotRead && reader.hasMore()) {
            String word = reader.readWord();
            if (word.equals("edge")) {
                edgesAreNotRead = false;
                continue;
            }
            allEdges.add(word);
        }
        if (edgesAreNotRead) {
            throw new SyntaxException("Missing \"edge\"");
        }
        if (allEdges.size() > 2) {
            throw new SyntaxException("Too many sides. Should use only 2");
        }
        Side sideHorizontal = Side.TOP;
        Side sideVertical = Side.LEFT;
        boolean isFirstHorizontal = false;
        if (allEdges.size() > 0) {
            side = Side.fromString((String)allEdges.get(0));
            if (side == Side.TOP || side == Side.BOTTOM) {
                isFirstHorizontal = true;
                sideHorizontal = side;
            } else {
                sideVertical = side;
            }
        }
        if (allEdges.size() > 1) {
            side = Side.fromString((String)allEdges.get(1));
            if (side == Side.TOP || side == Side.BOTTOM) {
                if (isFirstHorizontal) {
                    throw new SyntaxException("Cannot use theses sides: " + (String)allEdges.get(0) + " " + (String)allEdges.get(1));
                }
                sideHorizontal = side;
            } else {
                if (!isFirstHorizontal) {
                    throw new SyntaxException("Cannot use theses sides: " + (String)allEdges.get(0) + " " + (String)allEdges.get(1));
                }
                sideVertical = side;
            }
        }
        if ((objectName = reader.readWord()).isEmpty()) {
            throw new SyntaxException("Missing object name");
        }
        List<Location> locations = Expectations.locations().read(reader);
        return new SpecOn(objectName, sideHorizontal, sideVertical, locations);
    }
}

