/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecText;
import java.util.LinkedList;

public class SpecTextProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        LinkedList<String> textOperations = new LinkedList<String>();
        SpecText.Type textCheckType = null;
        while (textCheckType == null && reader.hasMoreNormalSymbols()) {
            String word = reader.readWord();
            if (word.isEmpty()) {
                throw new SyntaxException("Expected text check type, but got nothing");
            }
            if (SpecText.Type.isValid(word)) {
                textCheckType = SpecText.Type.fromString(word);
                continue;
            }
            textOperations.add(word);
        }
        String expectedText = Expectations.doubleQuotedText().read(reader);
        if (reader.hasMoreNormalSymbols()) {
            throw new SyntaxException("Too many arguments for spec: " + reader.getTheRest().trim());
        }
        return new SpecText(textCheckType, expectedText, textOperations);
    }
}

