/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.specs.SpecObjectWithErrorRate;

public class SpecCentered
extends SpecObjectWithErrorRate {
    private Alignment alignment;
    private Location location;

    public SpecCentered() {
    }

    public SpecCentered(String object, Alignment alignment, Location location) {
        this.setObject(object);
        this.alignment = alignment;
        this.location = location;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public SpecCentered withErrorRate(int errorRate) {
        this.setErrorRate(errorRate);
        return this;
    }

    public static enum Location {
        ON("on"),
        INSIDE("inside");

        private String name;

        private Location(String name) {
            this.name = name;
        }

        public static Location fromString(String locationText) {
            for (Location location : Location.values()) {
                if (!location.name.equals(locationText)) continue;
                return location;
            }
            throw new IllegalArgumentException("Can't read location: " + locationText);
        }

        public static boolean isValid(String locationText) {
            for (Location location : Location.values()) {
                if (!location.name.equals(locationText)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Alignment {
        ALL,
        VERTICALLY,
        HORIZONTALLY;


        public static Alignment fromString(String alignmentText) {
            if ("vertically".equals(alignmentText)) {
                return VERTICALLY;
            }
            if ("horizontally".equals(alignmentText)) {
                return HORIZONTALLY;
            }
            if ("all".equals(alignmentText)) {
                return ALL;
            }
            throw new IllegalArgumentException("Can't read alignment: " + alignmentText);
        }
    }
}

