/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs.page;

import com.galenframework.specs.Place;
import com.galenframework.specs.page.ObjectSpecs;
import java.util.LinkedList;
import java.util.List;

public class PageSection {
    private List<ObjectSpecs> objects = new LinkedList<ObjectSpecs>();
    private String name;
    private Place place;
    private List<PageSection> sections = new LinkedList<PageSection>();

    public PageSection() {
    }

    public PageSection(String name) {
        this.setName(name);
    }

    public PageSection(String name, Place place) {
        this.name = name;
        this.place = place;
    }

    public List<ObjectSpecs> getObjects() {
        return this.objects;
    }

    public void setObjects(List<ObjectSpecs> objects) {
        this.objects = objects;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PageSection> getSections() {
        return this.sections;
    }

    public void setSections(List<PageSection> sections) {
        this.sections = sections;
    }

    public void addSubSection(PageSection subSection) {
        this.getSections().add(subSection);
    }

    public void mergeSection(PageSection section) {
        if (section.getObjects() != null) {
            if (this.objects == null) {
                this.objects = new LinkedList<ObjectSpecs>();
            }
            for (ObjectSpecs object : section.getObjects()) {
                this.objects.add(object);
            }
        }
        if (section.getSections() != null) {
            if (this.sections == null) {
                this.sections = new LinkedList<PageSection>();
            }
            for (PageSection subSection : section.getSections()) {
                this.sections.add(subSection);
            }
        }
    }

    public void addObjects(ObjectSpecs objectSpecs) {
        if (this.objects == null) {
            this.objects = new LinkedList<ObjectSpecs>();
        }
        this.objects.add(objectSpecs);
    }

    public boolean isEmpty() {
        return this.countAllObjectsRecursively() == 0;
    }

    private int countAllObjectsRecursively() {
        int amount = 0;
        if (this.objects != null) {
            amount = this.objects.size();
        }
        if (this.sections != null) {
            for (PageSection subSection : this.sections) {
                amount += subSection.countAllObjectsRecursively();
            }
        }
        return amount;
    }

    public PageSection cleanSection() {
        PageSection cleanedSection = new PageSection(this.name, this.place);
        cleanedSection.setObjects(this.objects);
        if (this.sections != null) {
            for (PageSection subSection : this.sections) {
                PageSection cleanedSubSection = subSection.cleanSection();
                if (cleanedSubSection.isEmpty()) continue;
                cleanedSection.getSections().add(cleanedSubSection);
            }
        }
        return cleanedSection;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }
}

