/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.api.mutation.GalenMutate;
import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.suite.actions.mutation.MutationOptions;
import com.galenframework.suite.actions.mutation.MutationReport;
import com.galenframework.utils.GalenUtils;
import com.galenframework.validation.ValidationListener;
import java.util.List;
import java.util.Objects;

public class GalenPageActionMutate
extends GalenPageAction {
    private String specPath;
    private List<String> includedTags;
    private List<String> excludedTags;
    private MutationOptions mutationOptions = new MutationOptions();

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws Exception {
        MutationReport mutationReport = GalenMutate.checkAllMutations(browser, this.specPath, this.includedTags, this.excludedTags, this.mutationOptions, this.getCurrentProperties(), validationListener);
        if (mutationReport.getInitialLayoutReport() != null) {
            GalenUtils.attachLayoutReport(mutationReport.getInitialLayoutReport(), report, this.specPath, this.includedTags);
        }
        GalenUtils.attachMutationReport(mutationReport, report, this.specPath, this.includedTags);
    }

    public GalenPageActionMutate withSpec(String specPath) {
        this.specPath = specPath;
        return this;
    }

    public GalenPageActionMutate withIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
        return this;
    }

    public GalenPageActionMutate withExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
        return this;
    }

    public GalenPageActionMutate withOriginalCommand(String originalCommand) {
        this.setOriginalCommand(originalCommand);
        return this;
    }

    public GalenPageActionMutate withMutationOptions(MutationOptions mutationOptions) {
        this.mutationOptions = mutationOptions;
        return this;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GalenPageActionMutate that = (GalenPageActionMutate)o;
        return Objects.equals(this.specPath, that.specPath) && Objects.equals(this.includedTags, that.includedTags) && Objects.equals(this.excludedTags, that.excludedTags) && Objects.equals(this.mutationOptions, that.mutationOptions);
    }

    public int hashCode() {
        return Objects.hash(this.specPath, this.includedTags, this.excludedTags, this.mutationOptions);
    }

    public String toString() {
        return "GalenPageActionMutate{specPath='" + this.specPath + '\'' + ", includedTags=" + this.includedTags + ", excludedTags=" + this.excludedTags + ", mutationOptions=" + this.mutationOptions + '}';
    }
}

