/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.GalenSuiteLineProcessor;
import java.util.LinkedList;
import java.util.List;

public abstract class Node<T> {
    private int level = 0;
    private Node<?> parent;
    private Place place;
    private String text;
    private int spacesIndentation = 0;
    private List<Node<?>> childNodes = new LinkedList();

    public Node(String text, Place line) {
        this.setText(text);
        this.setPlace(line);
        this.setSpacesIndentation(this.calculateSpacesIndentation());
    }

    private int calculateSpacesIndentation() {
        int spaces = 0;
        if (this.text != null) {
            return GalenSuiteLineProcessor.calculateIndentationSpaces(this.text);
        }
        return spaces;
    }

    protected void add(Node<?> childNode) {
        childNode.parent = this;
        childNode.level = this.level + 1;
        int spaceDiff = childNode.getSpacesIndentation() - this.getSpacesIndentation();
        if (spaceDiff > 8) {
            throw new SyntaxException(childNode.place, "Incorrect indentation. Should use from 1 to 8 spaces");
        }
        if (this.getChildNodes().size() > 0 && this.getChildNodes().get(0).getSpacesIndentation() != childNode.getSpacesIndentation()) {
            throw new SyntaxException(childNode.place, "Incorrect indentation. Amount of spaces in indentation should be the same within one level");
        }
        this.getChildNodes().add(childNode);
    }

    public abstract T build(VarsContext var1);

    public Node<?> findProcessingNodeByIndentation(int spaces) {
        if (this.spacesIndentation < spaces) {
            return this;
        }
        return this.parent.findProcessingNodeByIndentation(spaces);
    }

    public abstract Node<?> processNewNode(String var1, Place var2);

    public List<Node<?>> getChildNodes() {
        return this.childNodes;
    }

    public Place getPlace() {
        return this.place;
    }

    public String getArguments() {
        return this.text.trim();
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public int getSpacesIndentation() {
        return this.spacesIndentation;
    }

    public void setSpacesIndentation(int spacesIndentation) {
        this.spacesIndentation = spacesIndentation;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

