/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.page.Rect;
import com.galenframework.reports.model.LayoutMeta;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Side;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SimpleValidationResult;

public class MetaBasedValidation {
    private final String firstObject;
    private final String secondObject;
    private final Range expectedRange;
    private Side firstEdge = Side.LEFT;
    private Side secondEdge = Side.LEFT;
    private boolean isInverted = false;

    private MetaBasedValidation(String firstObject, String secondObject, Range expectedRange) {
        this.firstObject = firstObject;
        this.secondObject = secondObject;
        this.expectedRange = expectedRange;
    }

    public static MetaBasedValidation forObjectsWithRange(String firstObject, String secondObject, Range expectedRange) {
        return new MetaBasedValidation(firstObject, secondObject, expectedRange);
    }

    public MetaBasedValidation withBothEdges(Side side) {
        this.firstEdge = side;
        this.secondEdge = side;
        return this;
    }

    public SimpleValidationResult validate(Rect firstArea, Rect secondArea, PageValidation pageValidation, String direction) {
        int offset = this.getOffset(firstArea, secondArea);
        double calculatedOffset = pageValidation.convertValue(this.expectedRange, offset);
        if (!this.expectedRange.holds(calculatedOffset)) {
            if (this.expectedRange.isPercentage()) {
                int precision = this.expectedRange.findPrecision();
                String actualDistance = String.format("%s%% [%dpx]", new RangeValue(calculatedOffset, precision).toString(), offset);
                return SimpleValidationResult.error(String.format("%s %s", actualDistance, direction), LayoutMeta.distance(this.firstObject, this.firstEdge, this.secondObject, this.secondEdge, this.expectedRange.prettyString("%"), actualDistance));
            }
            return SimpleValidationResult.error(String.format("%dpx %s", offset, direction), LayoutMeta.distance(this.firstObject, this.firstEdge, this.secondObject, this.secondEdge, this.expectedRange.prettyString(), offset + "px"));
        }
        return SimpleValidationResult.success(LayoutMeta.distance(this.firstObject, this.firstEdge, this.secondObject, this.secondEdge, this.expectedRange.prettyString(), offset + "px"));
    }

    private int getOffset(Rect firstArea, Rect secondArea) {
        int offset = firstArea.getEdgePosition(this.firstEdge) - secondArea.getEdgePosition(this.secondEdge);
        if (this.isInverted) {
            return -offset;
        }
        return offset;
    }

    public MetaBasedValidation withInvertedCalculation(boolean isInverted) {
        this.isInverted = isInverted;
        return this;
    }

    public MetaBasedValidation withFirstEdge(Side firstEdge) {
        this.firstEdge = firstEdge;
        return this;
    }

    public MetaBasedValidation withSecondEdge(Side secondEdge) {
        this.secondEdge = secondEdge;
        return this;
    }
}

