/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.config.GalenConfig;
import com.galenframework.page.PageElement;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Spec;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.ValidationUtils;

public abstract class SpecValidation<T extends Spec> {
    protected static final String OBJECT_WITH_NAME_S_IS_NOT_DEFINED_IN_PAGE_SPEC = "Cannot find locator for \"%s\" in page spec";
    protected static final String OBJECT_S_IS_ABSENT_ON_PAGE = "\"%s\" is absent on page";
    protected static final String OBJECT_S_IS_NOT_VISIBLE_ON_PAGE = "\"%s\" is not visible on page";

    public abstract ValidationResult check(PageValidation var1, String var2, T var3) throws ValidationErrorException;

    protected void checkAvailability(PageElement object, String objectName) throws ValidationErrorException {
        if (GalenConfig.getConfig().shouldCheckVisibilityGlobally()) {
            if (object == null) {
                throw new ValidationErrorException(String.format(OBJECT_WITH_NAME_S_IS_NOT_DEFINED_IN_PAGE_SPEC, objectName));
            }
            if (!object.isPresent()) {
                throw new ValidationErrorException(String.format(OBJECT_S_IS_ABSENT_ON_PAGE, objectName));
            }
            if (!object.isVisible()) {
                throw new ValidationErrorException(String.format(OBJECT_S_IS_NOT_VISIBLE_ON_PAGE, objectName));
            }
        }
    }

    protected String getReadableRangeAndValue(Range range, double realValue, double convertedValue, PageValidation pageValidation) {
        if (range.isPercentage()) {
            int objectValue = pageValidation.getObjectValue(range.getPercentageOfValue());
            return String.format("%s%% [%dpx] %s %s", new RangeValue(convertedValue, range.findPrecision()).toString(), (int)realValue, range.getErrorMessageSuffix(), ValidationUtils.rangeCalculatedFromPercentage(range, objectValue));
        }
        return String.format("%spx %s", new RangeValue(realValue, range.findPrecision()).toString(), range.getErrorMessageSuffix());
    }
}

