/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.reports.model.LayoutMeta;
import com.galenframework.specs.Spec;
import com.galenframework.validation.ImageComparison;
import com.galenframework.validation.ValidationError;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ValidationErrorException
extends Exception {
    private List<String> errorMessages;
    private ImageComparison imageComparison;
    private List<ValidationObject> validationObjects;
    private List<ValidationResult> childValidationResults;
    private List<LayoutMeta> meta;
    private static final long serialVersionUID = -1566513657187992205L;

    public ValidationErrorException() {
    }

    public ValidationErrorException(List<ValidationObject> validationObjects, List<String> errorMessages) {
        this.validationObjects = validationObjects;
        this.errorMessages = errorMessages;
    }

    public ValidationErrorException(String paramString, Throwable paramThrowable) {
        super(paramString, paramThrowable);
        this.withMessage(paramString);
    }

    public ValidationErrorException withMessage(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new LinkedList<String>();
        }
        this.errorMessages.add(message);
        return this;
    }

    public ValidationErrorException withValidationObject(ValidationObject validationObject) {
        if (this.validationObjects == null) {
            this.validationObjects = new LinkedList<ValidationObject>();
        }
        this.validationObjects.add(validationObject);
        return this;
    }

    public ValidationErrorException(String paramString) {
        super(paramString);
        this.withMessage(paramString);
    }

    public ValidationErrorException(Throwable paramThrowable) {
        super(paramThrowable);
        this.setErrorMessages(Arrays.asList(paramThrowable.getClass().getName() + ": " + paramThrowable.getMessage()));
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public List<ValidationObject> getValidationObjects() {
        return this.validationObjects;
    }

    public void setValidationObjects(List<ValidationObject> validationObjects) {
        this.validationObjects = validationObjects;
    }

    public ValidationErrorException withMessages(List<String> messages) {
        this.setErrorMessages(messages);
        return this;
    }

    public ValidationResult asValidationResult(Spec spec) {
        ValidationResult validationResult = new ValidationResult(spec, this.getValidationObjects(), new ValidationError(this.getErrorMessages(), this.getImageComparison()), this.getMeta());
        validationResult.setChildValidationResults(this.childValidationResults);
        return validationResult;
    }

    public ImageComparison getImageComparison() {
        return this.imageComparison;
    }

    public void setImageComparison(ImageComparison imageComparison) {
        this.imageComparison = imageComparison;
    }

    public ValidationErrorException withImageComparison(ImageComparison imageComparison) {
        this.setImageComparison(imageComparison);
        return this;
    }

    public ValidationErrorException withValidationObjects(List<ValidationObject> validationObjects) {
        if (this.validationObjects == null) {
            this.validationObjects = validationObjects;
        } else {
            this.validationObjects.addAll(validationObjects);
        }
        return this;
    }

    public ValidationErrorException withChildValidationResults(List<ValidationResult> childValidationResults) {
        this.setChildValidationResults(childValidationResults);
        return this;
    }

    public void setChildValidationResults(List<ValidationResult> childValidationResults) {
        this.childValidationResults = childValidationResults;
    }

    public List<ValidationResult> getChildValidationResults() {
        return this.childValidationResults;
    }

    public List<LayoutMeta> getMeta() {
        return this.meta;
    }

    public void setMeta(List<LayoutMeta> meta) {
        this.meta = meta;
    }

    public ValidationErrorException withMeta(List<LayoutMeta> meta) {
        this.setMeta(meta);
        return this;
    }
}

