/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.page.Rect;
import com.galenframework.specs.Location;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Side;
import com.galenframework.specs.Spec;
import com.galenframework.validation.PageValidation;
import java.util.LinkedList;
import java.util.List;

public class ValidationUtils {
    public static String verifyLocation(Rect mainArea, Rect secondArea, Location location, PageValidation pageValidation, Spec spec, OffsetProvider offsetProvider) {
        LinkedList<String> messages = new LinkedList<String>();
        Range range = location.getRange();
        for (Side side : location.getSides()) {
            int offset = offsetProvider.getOffsetForSide(mainArea, secondArea, side, spec);
            double calculatedOffset = pageValidation.convertValue(range, offset);
            if (range.holds(calculatedOffset)) continue;
            if (range.isPercentage()) {
                int precision = range.findPrecision();
                messages.add(String.format("%s%% [%dpx] %s", new Object[]{new RangeValue(calculatedOffset, precision).toString(), offset, side}));
                continue;
            }
            messages.add(String.format("%dpx %s", new Object[]{offset, side}));
        }
        if (messages.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            boolean comma = false;
            for (String message : messages) {
                if (comma) {
                    buffer.append(" and ");
                }
                buffer.append(message);
                comma = true;
            }
            buffer.append(' ');
            buffer.append(range.getErrorMessageSuffix());
            if (range.isPercentage()) {
                int objectValue = pageValidation.getObjectValue(range.getPercentageOfValue());
                buffer.append(' ');
                buffer.append(ValidationUtils.rangeCalculatedFromPercentage(range, objectValue));
            }
            return buffer.toString();
        }
        return null;
    }

    public static String rangeCalculatedFromPercentage(Range range, int objectValue) {
        if (range.getRangeType() == Range.RangeType.BETWEEN) {
            int from = (int)((double)objectValue * range.getFrom().asDouble() / 100.0);
            int to = (int)((double)objectValue * range.getTo().asDouble() / 100.0);
            return String.format("[%d to %dpx]", from, to);
        }
        RangeValue rangeValue = ValidationUtils.takeNonNullValue(range.getFrom(), range.getTo());
        int converted = (int)((double)objectValue * rangeValue.asDouble() / 100.0);
        return "[" + converted + "px]";
    }

    private static RangeValue takeNonNullValue(RangeValue from, RangeValue to) {
        if (from != null) {
            return from;
        }
        if (to != null) {
            return to;
        }
        throw new NullPointerException("Both range values are null");
    }

    public static String joinErrorMessagesForObject(List<String> messages, String objectName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("\"%s\" is ", objectName));
        buffer.append(ValidationUtils.joinMessages(messages, " and "));
        return buffer.toString();
    }

    public static String joinMessages(List<String> messages, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean comma = false;
        for (String message : messages) {
            if (comma) {
                buffer.append(separator);
            }
            buffer.append(message);
            comma = true;
        }
        return buffer.toString();
    }

    public static interface OffsetProvider {
        public int getOffsetForSide(Rect var1, Rect var2, Side var3, Spec var4);
    }
}

