/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecAligned;
import com.galenframework.specs.SpecObjectWithErrorRate;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.List;

public abstract class SpecValidationAligned<T extends SpecAligned>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement childObject = pageValidation.findPageElement(((SpecObjectWithErrorRate)spec).getObject());
        this.checkAvailability(childObject, ((SpecObjectWithErrorRate)spec).getObject());
        int offset = Math.abs(this.getOffset(spec, mainObject, childObject));
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainObject.getArea(), objectName), new ValidationObject(childObject.getArea(), ((SpecObjectWithErrorRate)spec).getObject()));
        if (offset > Math.abs(((SpecObjectWithErrorRate)spec).getErrorRate())) {
            throw new ValidationErrorException(objects, Arrays.asList(this.errorMisalignedObjects(objectName, ((SpecObjectWithErrorRate)spec).getObject(), spec, offset)));
        }
        return new ValidationResult((Spec)spec, objects);
    }

    private String errorMisalignedObjects(String objectName, String misalignedObjectName, T spec, int offset) {
        return String.format("\"%s\" is not aligned %s with \"%s\". Offset is %dpx", misalignedObjectName, this.getAligmentText(spec), objectName, offset);
    }

    protected abstract String getAligmentText(T var1);

    protected abstract int getOffset(T var1, PageElement var2, PageElement var3);
}

