/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.rainbow4j.Rainbow4J;
import com.galenframework.rainbow4j.colorscheme.CustomSpectrum;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.SpecColorScheme;
import com.galenframework.specs.colors.ColorRange;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SpecValidationColorScheme
extends SpecValidation<SpecColorScheme> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecColorScheme spec) throws ValidationErrorException {
        CustomSpectrum spectrum;
        int colorTolerance = GalenConfig.getConfig().getIntProperty(GalenProperty.SPEC_COLORSCHEME_TOLERANCE, 0, 256);
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        BufferedImage pageImage = pageValidation.getPage().getScreenshotImage();
        Rect area = mainObject.getArea();
        if (pageImage.getWidth() < area.getLeft() + area.getWidth() || pageImage.getHeight() < area.getTop() + area.getHeight()) {
            throw new ValidationErrorException().withValidationObject(new ValidationObject(area, objectName)).withMessage("Can't fetch image for \"object\" as it is outside of screenshot");
        }
        List classifiers = spec.getColorRanges().stream().map(ColorRange::getColorClassifier).collect(Collectors.toList());
        try {
            spectrum = Rainbow4J.readCustomSpectrum((BufferedImage)pageImage, classifiers, (Rectangle)new Rectangle(area.getLeft(), area.getTop(), area.getWidth(), area.getHeight()), (int)colorTolerance);
        }
        catch (Exception e) {
            throw new ValidationErrorException(String.format("Couldn't fetch spectrum for \"%s\"", objectName));
        }
        LinkedList<String> messages = new LinkedList<String>();
        for (ColorRange colorRange : spec.getColorRanges()) {
            double realPercentage = 0.0;
            int totalPixels = spectrum.getTotalPixels();
            if (totalPixels > 0 && (realPercentage = (double)spectrum.getCollectedColors().getOrDefault(colorRange.getName(), 0).intValue() / (double)totalPixels * 100.0) > 151.0) {
                boolean bl = false;
            }
            if (colorRange.getRange().holds(realPercentage)) continue;
            String realPercentageText = new RangeValue(realPercentage, colorRange.getRange().findPrecision()).toString();
            messages.add(String.format("color %s on \"%s\" is %s%% %s", colorRange.getName(), objectName, realPercentageText, colorRange.getRange().getErrorMessageSuffix("%")));
        }
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(area, objectName));
        if (messages.size() > 0) {
            throw new ValidationErrorException().withValidationObjects(objects).withMessages(messages);
        }
        return new ValidationResult(spec, objects);
    }
}

