/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.SpecHorizontally;
import com.galenframework.validation.specs.SpecValidationAligned;

public class SpecValidationHorizontally
extends SpecValidationAligned<SpecHorizontally> {
    @Override
    protected String getAligmentText(SpecHorizontally spec) {
        return String.format("horizontally %s", spec.getAlignment().toString());
    }

    @Override
    protected int getOffset(SpecHorizontally spec, PageElement mainObject, PageElement childObject) {
        Rect mainArea = mainObject.getArea();
        Rect childArea = childObject.getArea();
        switch (spec.getAlignment()) {
            case CENTERED: {
                return Math.abs(childArea.getTop() + childArea.getHeight() / 2 - (mainArea.getTop() + mainArea.getHeight() / 2));
            }
            case TOP: {
                return Math.abs(childArea.getTop() - mainArea.getTop());
            }
            case BOTTOM: {
                return Math.abs(childArea.getTop() + childArea.getHeight() - (mainArea.getTop() + mainArea.getHeight()));
            }
            case ALL: {
                return Math.max(Math.abs(childArea.getTop() - mainArea.getTop()), Math.abs(childArea.getHeight() - mainArea.getHeight()));
            }
        }
        return 0;
    }
}

