/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public class ImageHandler {
    private ByteBuffer bytes;
    private int width;
    private int height;
    public static final int BLOCK_SIZE = 4;

    public ImageHandler(BufferedImage image) {
        this.bytes = ImageHandler.readRgbModelFrom(image);
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageHandler(int width, int height) {
        this.width = width;
        this.height = height;
        this.bytes = ByteBuffer.allocateDirect(width * height * 4);
    }

    private static ByteBuffer readRgbModelFrom(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] pixels = new int[w * h];
        image.getRGB(0, 0, w, h, pixels, 0, w);
        ByteBuffer rgbBytes = ByteBuffer.allocateDirect(w * h * 4);
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                int index = r * w + c;
                int indexRgb = r * w * 4 + c * 4;
                rgbBytes.put(indexRgb, (byte)(pixels[index] >> 16 & 0xFF));
                rgbBytes.put(indexRgb + 1, (byte)(pixels[index] >> 8 & 0xFF));
                rgbBytes.put(indexRgb + 2, (byte)(pixels[index] & 0xFF));
                rgbBytes.put(indexRgb + 3, (byte)(pixels[index] >> 24 & 0xFF));
            }
        }
        return rgbBytes;
    }

    public Color pickColor(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            int k = y * this.width * 4 + x * 4;
            return new Color(this.bytes.get(k) & 0xFF, this.bytes.get(k + 1) & 0xFF, this.bytes.get(k + 2) & 0xFF, this.bytes.get(k + 3) & 0xFF);
        }
        return new Color(0, 0, 0);
    }

    public static long colorDiff(Color left, Color right) {
        if (left.getAlpha() > 128 && right.getAlpha() > 128) {
            return Math.abs(left.getRed() - right.getRed()) + Math.abs(left.getGreen() - right.getGreen()) + Math.abs(left.getBlue() - right.getBlue());
        }
        return 0L;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                int index = r * this.width * 4 + c * 4;
                int red = this.bytes.get(index) & 0xFF;
                int green = this.bytes.get(index + 1) & 0xFF;
                int blue = this.bytes.get(index + 2) & 0xFF;
                int alpha = this.bytes.get(index + 3) & 0xFF;
                int rgb = alpha << 24 | red << 16 | green << 8 | blue;
                image.setRGB(c, r, rgb);
            }
        }
        return image;
    }

    public void applyFilter(ImageFilter filter, Rectangle area) {
        filter.apply(this.bytes, this.width, this.height, area);
    }

    public void setRGBA(int x, int y, int r, int g, int b, int a) {
        int k = y * this.width * 4 + x * 4;
        this.bytes.put(k, (byte)(r & 0xFF));
        this.bytes.put(k + 1, (byte)(g & 0xFF));
        this.bytes.put(k + 2, (byte)(b & 0xFF));
        this.bytes.put(k + 3, (byte)(a & 0xFF));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public void applyFilter(ImageFilter filter) {
        this.applyFilter(filter, new Rectangle(0, 0, this.width, this.height));
    }
}

