/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.github.anicolaspp.ojai.DocumentProjector;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.rowcol.KeyValue;
import java.util.stream.Stream;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.Connection;
import scala.Tuple2;

public class ConditionEvaluator {
    private ConditionNode condition;
    private Connection connection;

    public ConditionEvaluator(ConditionNode conditionNode, Connection connection) {
        this.condition = conditionNode;
        this.connection = connection;
    }

    public boolean evalOn(Document document) {
        return this.evalCondition(this.condition, document);
    }

    private boolean evalCondition(ConditionNode conditionNode2, Document document) {
        if (conditionNode2.isLeaf()) {
            ConditionLeaf conditionLeaf = (ConditionLeaf)conditionNode2;
            Document document2 = new DocumentProjector(document, this.connection).projectPath(conditionLeaf.getField().asPathString());
            return this.getAllLeafValues(document2, "").filter(tuple2 -> ((String)tuple2._1).equals(conditionLeaf.getField().asPathString().replace("[]", ""))).map(Tuple2::_2).anyMatch(value -> this.cmp(conditionLeaf.getValue(), (Value)value));
        }
        ConditionBlock conditionBlock = (ConditionBlock)conditionNode2;
        if (conditionBlock.getType() == ConditionBlock.BlockType.and) {
            return conditionBlock.getChildren().stream().allMatch(conditionNode -> this.evalCondition((ConditionNode)conditionNode, document));
        }
        if (conditionBlock.getType() == ConditionBlock.BlockType.or) {
            return conditionBlock.getChildren().stream().anyMatch(conditionNode -> this.evalCondition((ConditionNode)conditionNode, document));
        }
        return false;
    }

    private boolean cmp(KeyValue keyValue, Value value) {
        switch (value.getType()) {
            case NULL: {
                return keyValue.getType().getCode() == 1;
            }
            case BOOLEAN: {
                return keyValue.getBoolean() == value.getBoolean();
            }
            case STRING: {
                return keyValue.getString().equals(value.getString());
            }
            case BYTE: {
                return keyValue.getByte() == value.getByte();
            }
            case SHORT: {
                return keyValue.getShort() == value.getShort();
            }
            case INT: {
                return keyValue.getInt() == value.getInt();
            }
            case LONG: {
                return keyValue.getLong() == value.getLong();
            }
            case FLOAT: {
                return keyValue.getFloat() == value.getFloat();
            }
            case DOUBLE: {
                return keyValue.getDouble() == value.getDouble();
            }
            case DECIMAL: {
                return keyValue.getDecimal().equals(value.getDecimal());
            }
            case DATE: {
                return keyValue.getDate() == value.getDate();
            }
            case TIME: {
                return keyValue.getTime() == value.getTime();
            }
            case TIMESTAMP: {
                return keyValue.getTimestamp() == value.getTimestamp();
            }
            case INTERVAL: {
                return keyValue.getInterval() == value.getInterval();
            }
            case BINARY: {
                return keyValue.getBinary() == value.getBinary();
            }
            case MAP: {
                return keyValue.getMap() == value.getMap();
            }
            case ARRAY: {
                return keyValue.getList() == value.getList();
            }
        }
        return false;
    }

    private String add(String string, String string2) {
        if (string.isEmpty()) {
            return string2;
        }
        return string + "." + string2;
    }

    private Stream<Tuple2<String, Value>> getAllLeafValues(Document document, String string) {
        return document.asMap().keySet().stream().flatMap(string2 -> {
            Value value = document.getValue(string2);
            if (value.getType() == Value.Type.ARRAY) {
                return value.getList().stream().map(object -> this.connection.newDocument(object)).flatMap(document -> this.getAllLeafValues((Document)document, this.add(string, (String)string2)));
            }
            if (value.getType() == Value.Type.MAP) {
                return this.getAllLeafValues(this.connection.newDocument(value.getMap()), this.add(string, (String)string2));
            }
            return Stream.of(new Tuple2((Object)this.add(string, (String)string2), (Object)value));
        });
    }
}

