/*
 * Decompiled with CFR 0.152.
 */
package com.github.anicolaspp.ojai;

import com.github.anicolaspp.ojai.LinearProjector;
import com.github.anicolaspp.ojai.ListProjector;
import com.github.anicolaspp.ojai.PathProjector;
import org.ojai.Document;
import org.ojai.store.Connection;

public class DocumentProjector
implements PathProjector {
    private Document document;
    private Connection connection;

    public DocumentProjector(Document document, Connection connection) {
        this.document = document;
        this.connection = connection;
    }

    @Override
    public Document projectPath(String string) {
        if (this.document == null) {
            return this.connection.newDocument();
        }
        if (this.isEmpty(string)) {
            return this.document;
        }
        if (this.needsListProjector(string)) {
            return new ListProjector(this.document, this.connection).projectPath(string);
        }
        return new LinearProjector(this.document, this.connection).projectPath(string);
    }

    private boolean isEmpty(String string) {
        String[] stringArray = string.replace("\"", "").split("\\.");
        return stringArray.length == 0;
    }

    private boolean needsListProjector(String string) {
        String[] stringArray = string.replace("\"", "").split("\\.");
        String string2 = stringArray[0];
        return string2.contains("[]");
    }
}

