/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.AvroInternalExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u001f\u0010\u000e\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/avrokotlin/avro4k/KotlinxSerializationDatumReader;", "T", "Lorg/apache/avro/io/DatumReader;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lkotlinx/serialization/DeserializationStrategy;Lcom/github/avrokotlin/avro4k/Avro;)V", "writerSchema", "Lorg/apache/avro/Schema;", "setSchema", "", "schema", "read", "reuse", "decoder", "Lorg/apache/avro/io/Decoder;", "(Ljava/lang/Object;Lorg/apache/avro/io/Decoder;)Ljava/lang/Object;", "core"})
final class KotlinxSerializationDatumReader<T>
implements DatumReader<T> {
    @NotNull
    private final DeserializationStrategy<T> deserializer;
    @NotNull
    private final Avro avro;
    private Schema writerSchema;

    public KotlinxSerializationDatumReader(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.deserializer = deserializer;
        this.avro = avro;
    }

    public void setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.writerSchema = schema;
    }

    public T read(@Nullable T reuse, @NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Schema schema = this.writerSchema;
        if (schema == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writerSchema");
            schema = null;
        }
        return AvroInternalExtensionsKt.decodeWithApacheDecoder(this.avro, schema, this.deserializer, decoder);
    }
}

