/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.DecodingStep;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.SerializationWorkflow;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.RecordDirectDecoderKt;
import com.github.avrokotlin.avro4k.internal.decoder.generic.AvroValueGenericDecoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.BooleanCompanionObject;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.Decoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J)\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J!\u00101\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001dH\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0005H\u0016J\b\u00105\u001a\u000206H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/direct/RecordDirectDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/direct/AbstractAvroDirectDecoder;", "writerRecordSchema", "Lorg/apache/avro/Schema;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryDecoder", "Lorg/apache/avro/io/Decoder;", "<init>", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/descriptors/SerialDescriptor;Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Decoder;)V", "classDescriptor", "Lcom/github/avrokotlin/avro4k/internal/SerializationWorkflow;", "currentDecodingStep", "Lcom/github/avrokotlin/avro4k/internal/DecodingStep$ValidatedDecodingStep;", "nextDecodingStepIndex", "", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "decodeElementIndex", "decodeDefault", "T", "element", "Lcom/github/avrokotlin/avro4k/internal/DecodingStep$GetDefaultValue;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lcom/github/avrokotlin/avro4k/internal/DecodingStep$GetDefaultValue;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeNotNullMark", "", "decodeNull", "", "decodeFixed", "Lorg/apache/avro/generic/GenericFixed;", "decodeInt", "decodeLong", "", "decodeBoolean", "decodeChar", "", "decodeString", "", "decodeDouble", "", "decodeFloat", "", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeEnum", "enumDescriptor", "decodeBytes", "", "core"})
public final class RecordDirectDecoder
extends AbstractAvroDirectDecoder {
    @NotNull
    private final Schema writerRecordSchema;
    @NotNull
    private final SerializationWorkflow classDescriptor;
    private DecodingStep.ValidatedDecodingStep currentDecodingStep;
    private int nextDecodingStepIndex;
    public Schema currentWriterSchema;

    public RecordDirectDecoder(@NotNull Schema writerRecordSchema, @NotNull SerialDescriptor descriptor, @NotNull Avro avro, @NotNull Decoder binaryDecoder) {
        Intrinsics.checkNotNullParameter((Object)writerRecordSchema, (String)"writerRecordSchema");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryDecoder, (String)"binaryDecoder");
        super(avro, binaryDecoder);
        this.writerRecordSchema = writerRecordSchema;
        this.classDescriptor = avro.getRecordResolver$core().resolveFields(this.writerRecordSchema, descriptor);
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        DecodingStep decodingStep;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        DecodingStep field = null;
        while (true) {
            if (this.nextDecodingStepIndex == this.classDescriptor.getDecoding().length) {
                return -1;
            }
            int n = this.nextDecodingStepIndex;
            this.nextDecodingStepIndex = n + 1;
            field = this.classDescriptor.getDecoding()[n];
            decodingStep = field;
            if (decodingStep instanceof DecodingStep.IgnoreOptionalElement) continue;
            if (!(decodingStep instanceof DecodingStep.SkipWriterField)) break;
            RecordDirectDecoderKt.access$skip(this.getBinaryDecoder(), ((DecodingStep.SkipWriterField)field).getSchema());
        }
        if (decodingStep instanceof DecodingStep.MissingElementValueFailure) {
            throw new SerializationException("Reader field '" + HelpersKt.getNonNullSerialName(descriptor) + '.' + descriptor.getElementName(((DecodingStep.MissingElementValueFailure)field).getElementIndex()) + "' has no corresponding field in writer schema " + this.writerRecordSchema);
        }
        if (decodingStep instanceof DecodingStep.DeserializeWriterField) {
            this.currentDecodingStep = (DecodingStep.ValidatedDecodingStep)field;
            this.setCurrentWriterSchema(((DecodingStep.DeserializeWriterField)field).getSchema());
            return ((DecodingStep.DeserializeWriterField)field).getElementIndex();
        }
        if (decodingStep instanceof DecodingStep.GetDefaultValue) {
            this.currentDecodingStep = (DecodingStep.ValidatedDecodingStep)field;
            this.setCurrentWriterSchema(((DecodingStep.GetDefaultValue)field).getSchema());
            return ((DecodingStep.GetDefaultValue)field).getElementIndex();
        }
        throw new NoWhenBranchMatchedException();
    }

    private final <T> T decodeDefault(DecodingStep.GetDefaultValue element, DeserializationStrategy<? extends T> deserializer) {
        return new AvroValueGenericDecoder(this.getAvro$core(), element.getDefaultValue(), this.getCurrentWriterSchema()).decodeSerializableValue(deserializer);
    }

    @Override
    public boolean decodeNotNullMark() {
        boolean bl;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            bl = super.decodeNotNullMark();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            bl = ((DecodingStep.GetDefaultValue)element).getDefaultValue() != null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @Nullable
    public Void decodeNull() {
        Void void_;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            void_ = super.decodeNull();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            if (((DecodingStep.GetDefaultValue)element).getDefaultValue() != null) {
                throw new SerializationException("Trying to decode a null value for a missing field while the default value is not null");
            }
            void_ = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return void_;
    }

    @Override
    @NotNull
    public GenericFixed decodeFixed() {
        GenericFixed genericFixed;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            genericFixed = super.decodeFixed();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            Object object = ((DecodingStep.GetDefaultValue)element).getDefaultValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.avro.generic.GenericFixed");
            genericFixed = (GenericFixed)object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return genericFixed;
    }

    @Override
    public int decodeInt() {
        int n;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            n = super.decodeInt();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            n = ((Number)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((IntCompanionObject)IntCompanionObject.INSTANCE))).intValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @Override
    public long decodeLong() {
        long l;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            l = super.decodeLong();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            l = ((Number)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE))).longValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    @Override
    public boolean decodeBoolean() {
        boolean bl;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            bl = super.decodeBoolean();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            bl = (Boolean)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((BooleanCompanionObject)BooleanCompanionObject.INSTANCE));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public char decodeChar() {
        char c;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            c = super.decodeChar();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            c = ((Character)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((CharCompanionObject)CharCompanionObject.INSTANCE))).charValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return c;
    }

    @Override
    @NotNull
    public String decodeString() {
        String string;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            string = super.decodeString();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            string = (String)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    public double decodeDouble() {
        double d;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            d = super.decodeDouble();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            d = ((Number)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((DoubleCompanionObject)DoubleCompanionObject.INSTANCE))).doubleValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return d;
    }

    @Override
    public float decodeFloat() {
        float f;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            f = super.decodeFloat();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            f = ((Number)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((FloatCompanionObject)FloatCompanionObject.INSTANCE))).floatValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return f;
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        T t;
        DecodingStep.ValidatedDecodingStep element;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            t = super.decodeSerializableValue(deserializer);
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            t = this.decodeDefault((DecodingStep.GetDefaultValue)element, deserializer);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return t;
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        int n;
        DecodingStep.ValidatedDecodingStep element;
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            n = super.decodeEnum(enumDescriptor);
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            n = ((Number)this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.serializer((IntCompanionObject)IntCompanionObject.INSTANCE))).intValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @Override
    @NotNull
    public byte[] decodeBytes() {
        byte[] byArray;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentDecodingStep;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentDecodingStep");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            byArray = super.decodeBytes();
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            byArray = (byte[])this.decodeDefault((DecodingStep.GetDefaultValue)element, (DeserializationStrategy)BuiltinSerializersKt.ByteArraySerializer());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }
}

