/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.decoder.generic.AbstractAvroGenericDecoder;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/generic/ArrayGenericDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder;", "collection", "", "", "writerSchema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Ljava/util/Collection;Lorg/apache/avro/Schema;Lcom/github/avrokotlin/avro4k/Avro;)V", "getAvro$core", "()Lcom/github/avrokotlin/avro4k/Avro;", "iterator", "", "currentItem", "decodedNullMark", "", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "decodeNotNullMark", "decodeValue", "decodeElementIndex", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeCollectionSize", "decodeSequentially", "core"})
public final class ArrayGenericDecoder
extends AbstractAvroGenericDecoder {
    @NotNull
    private final Collection<Object> collection;
    @NotNull
    private final Schema writerSchema;
    @NotNull
    private final Avro avro;
    @NotNull
    private final Iterator<Object> iterator;
    @Nullable
    private Object currentItem;
    private boolean decodedNullMark;

    public ArrayGenericDecoder(@NotNull Collection<? extends Object> collection, @NotNull Schema writerSchema, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.collection = collection;
        this.writerSchema = writerSchema;
        this.avro = avro;
        this.iterator = this.collection.iterator();
    }

    @Override
    @NotNull
    public Avro getAvro$core() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.writerSchema.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getElementType(...)");
        return schema;
    }

    @Override
    public boolean decodeNotNullMark() {
        this.decodedNullMark = true;
        this.currentItem = this.iterator.next();
        return this.currentItem != null;
    }

    @Override
    @NotNull
    public Object decodeValue() {
        Object value = this.decodedNullMark ? this.currentItem : this.iterator.next();
        this.decodedNullMark = false;
        Object object = value;
        if (object == null) {
            throw ExceptionsKt.DecodedNullError(this);
        }
        return object;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw ExceptionsKt.IllegalIndexedAccessError(this);
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.collection.size();
    }

    public boolean decodeSequentially() {
        return true;
    }
}

