/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder;

import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.NumberUtilsKt;
import com.github.avrokotlin.avro4k.internal.SerializerLocatorMiddleware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0006H&J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0006H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H&J\b\u0010\u0018\u001a\u00020\u0016H&J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H&J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001eH&J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020 H&J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\"H&J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020$H&J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020%H&J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H&J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H&J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020%H&J)\u0010+\u001a\u00020\u0016\"\u0004\b\u0000\u0010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H,0.2\u0006\u0010\u001a\u001a\u0002H,H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u00101\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0018\u00103\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\u0016H\u0016J\u0010\u00105\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H\u0016J\u0010\u00106\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H\u0016J\u0018\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u00109\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0010\u0010@\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0010\u0010B\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006E"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/AbstractAvroEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "<init>", "()V", "selectedUnionIndex", "", "currentWriterSchema", "Lorg/apache/avro/Schema;", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "getRecordEncoder", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getPolymorphicEncoder", "getMapEncoder", "collectionSize", "getArrayEncoder", "encodeUnionIndexUnchecked", "", "index", "encodeNullUnchecked", "encodeBooleanUnchecked", "value", "", "encodeIntUnchecked", "encodeLongUnchecked", "", "encodeFloatUnchecked", "", "encodeDoubleUnchecked", "", "encodeStringUnchecked", "Lorg/apache/avro/util/Utf8;", "", "encodeBytesUnchecked", "", "encodeFixedUnchecked", "encodeEnumUnchecked", "symbol", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "beginStructure", "beginCollection", "encodeUnionIndex", "encodeElement", "encodeNull", "encodeBytes", "encodeFixed", "encodeEnum", "enumDescriptor", "encodeBoolean", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "encodeFloat", "encodeDouble", "encodeChar", "", "encodeString", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractAvroEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAvroEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/AbstractAvroEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
public abstract class AbstractAvroEncoder
extends AbstractEncoder
implements AvroEncoder {
    private int selectedUnionIndex = -1;

    @Override
    @NotNull
    public abstract Schema getCurrentWriterSchema();

    public abstract void setCurrentWriterSchema(@NotNull Schema var1);

    @NotNull
    public abstract CompositeEncoder getRecordEncoder(@NotNull SerialDescriptor var1);

    @NotNull
    public abstract CompositeEncoder getPolymorphicEncoder(@NotNull SerialDescriptor var1);

    @NotNull
    public abstract CompositeEncoder getMapEncoder(@NotNull SerialDescriptor var1, int var2);

    @NotNull
    public abstract CompositeEncoder getArrayEncoder(@NotNull SerialDescriptor var1, int var2);

    public abstract void encodeUnionIndexUnchecked(int var1);

    public abstract void encodeNullUnchecked();

    public abstract void encodeBooleanUnchecked(boolean var1);

    public abstract void encodeIntUnchecked(int var1);

    public abstract void encodeLongUnchecked(long var1);

    public abstract void encodeFloatUnchecked(float var1);

    public abstract void encodeDoubleUnchecked(double var1);

    public abstract void encodeStringUnchecked(@NotNull Utf8 var1);

    public abstract void encodeStringUnchecked(@NotNull String var1);

    public abstract void encodeBytesUnchecked(@NotNull byte[] var1);

    public abstract void encodeFixedUnchecked(@NotNull byte[] var1);

    public abstract void encodeEnumUnchecked(@NotNull String var1);

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        SerializerLocatorMiddleware.INSTANCE.apply(serializer).serialize((Encoder)this, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            boolean nameChecked = false;
            if (this.getCurrentWriterSchema().isUnion()) {
                if (!AvroEncoderKt.trySelectNamedSchema((AvroEncoder)this, descriptor)) {
                    throw AvroEncoderKt.namedSchemaNotFoundInUnionError(this, HelpersKt.getNonNullSerialName(descriptor), HelpersKt.getAliases(descriptor), new Schema.Type[0]);
                }
                nameChecked = true;
            } else {
                nameChecked = false;
            }
            Schema.Type type = this.getCurrentWriterSchema().getType();
            if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) != 1) throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.RECORD, new Schema.Type[0]);
            if (!nameChecked && !HelpersKt.isFullNameOrAliasMatch(this.getCurrentWriterSchema(), descriptor)) throw AvroEncoderKt.fullNameOrAliasMismatchError(this, HelpersKt.getNonNullSerialName(descriptor), HelpersKt.getAliases(descriptor));
            compositeEncoder = this.getRecordEncoder(descriptor);
            return compositeEncoder;
        } else {
            if (!(serialKind instanceof PolymorphicKind)) throw new SerializationException("Unsupported structure kind: " + descriptor);
            compositeEncoder = this.getPolymorphicEncoder(descriptor);
        }
        return compositeEncoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.ARRAY)) {
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.ARRAY, new Schema.Type[0]);
            }
            Schema.Type type = this.getCurrentWriterSchema().getType();
            if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) != 2) throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.ARRAY, new Schema.Type[0]);
            compositeEncoder = this.getArrayEncoder(descriptor, collectionSize);
            return compositeEncoder;
        } else {
            if (!Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) throw new SerializationException("Unsupported collection kind: " + descriptor);
            if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.MAP)) {
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.MAP, new Schema.Type[0]);
            }
            Schema.Type type = this.getCurrentWriterSchema().getType();
            if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) != 3) throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.MAP, new Schema.Type[0]);
            compositeEncoder = this.getMapEncoder(descriptor, collectionSize);
        }
        return compositeEncoder;
    }

    @Override
    public void encodeUnionIndex(int index) {
        if (this.selectedUnionIndex != -1) {
            throw new SerializationException("Already selected union index: " + this.selectedUnionIndex + ", got " + index + ", for selected schema " + this.getCurrentWriterSchema());
        }
        Object e = this.getCurrentWriterSchema().getTypes().get(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        this.setCurrentWriterSchema((Schema)e);
        this.encodeUnionIndexUnchecked(index);
        this.selectedUnionIndex = index;
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.selectedUnionIndex = -1;
        return true;
    }

    public void encodeNull() {
        if (this.getCurrentWriterSchema().isUnion()) {
            if (!AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.NULL)) {
                throw new SerializationException("Cannot encode null value for non-nullable schema: " + this.getCurrentWriterSchema());
            }
        } else if (this.getCurrentWriterSchema().getType() != Schema.Type.NULL) {
            throw new SerializationException("Cannot encode null value for non-null schema: " + this.getCurrentWriterSchema());
        }
        this.encodeNullUnchecked();
    }

    @Override
    public void encodeBytes(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.BYTES) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING) && !AvroEncoderKt.trySelectFixedSchemaForSize(this, value.length)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.FIXED, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 4: {
                this.encodeBytesUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(new Utf8(value));
                break;
            }
            case 6: {
                this.encodeFixedUnchecked(AvroEncoderKt.ensureFixedSize(this, value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING, Schema.Type.FIXED};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.BYTES, typeArray);
            }
        }
    }

    @Override
    public void encodeFixed(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectFixedSchemaForSize(this, value.length) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.BYTES) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.FIXED, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 6: {
                this.encodeFixedUnchecked(AvroEncoderKt.ensureFixedSize(this, value));
                break;
            }
            case 4: {
                this.encodeBytesUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(new Utf8(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.FIXED, typeArray);
            }
        }
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        boolean nameChecked = false;
        if (this.getCurrentWriterSchema().isUnion()) {
            boolean bl;
            boolean it = bl = AvroEncoderKt.trySelectNamedSchema((AvroEncoder)this, enumDescriptor);
            boolean bl2 = false;
            nameChecked = it;
            if (!bl && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroEncoderKt.namedSchemaNotFoundInUnionError(this, HelpersKt.getNonNullSerialName(enumDescriptor), HelpersKt.getAliases(enumDescriptor), typeArray);
            }
        } else {
            nameChecked = false;
        }
        String enumName = enumDescriptor.getElementName(index);
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 7: {
                if (nameChecked || HelpersKt.isFullNameOrAliasMatch(this.getCurrentWriterSchema(), enumDescriptor)) {
                    this.encodeEnumUnchecked(enumName);
                    break;
                }
                throw AvroEncoderKt.fullNameOrAliasMismatchError(this, HelpersKt.getNonNullSerialName(enumDescriptor), HelpersKt.getAliases(enumDescriptor));
            }
            case 5: {
                this.encodeStringUnchecked(enumName);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.ENUM, typeArray);
            }
        }
    }

    public void encodeBoolean(boolean value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.BOOLEAN) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.BOOLEAN, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 8: {
                this.encodeBooleanUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.BOOLEAN, typeArray);
            }
        }
    }

    public void encodeByte(byte value) {
        this.encodeInt(value);
    }

    public void encodeShort(short value) {
        this.encodeInt(value);
    }

    public void encodeInt(int value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.INT) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.LONG) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 9: {
                this.encodeIntUnchecked(value);
                break;
            }
            case 10: {
                this.encodeLongUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
            }
        }
    }

    public void encodeLong(long value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.LONG) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.INT) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.LONG, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 9: {
                this.encodeIntUnchecked(NumberUtilsKt.toIntExact(value));
                break;
            }
            case 10: {
                this.encodeLongUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
            }
        }
    }

    public void encodeFloat(float value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.FLOAT) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.DOUBLE) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.DOUBLE, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.FLOAT, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 11: {
                this.encodeFloatUnchecked(value);
                break;
            }
            case 12: {
                this.encodeDoubleUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.DOUBLE, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.FLOAT, typeArray);
            }
        }
    }

    public void encodeDouble(double value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.DOUBLE) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.FLOAT) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.DOUBLE, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 11: {
                this.encodeFloatUnchecked(NumberUtilsKt.toFloatExact(value));
                break;
            }
            case 12: {
                this.encodeDoubleUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.DOUBLE, typeArray);
            }
        }
    }

    public void encodeChar(char value) {
        if (this.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.INT) && !AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 9: {
                this.encodeIntUnchecked(value);
                break;
            }
            case 5: {
                this.encodeStringUnchecked(String.valueOf(value));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
            }
        }
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!this.getCurrentWriterSchema().isUnion() || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.STRING) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.BYTES) || AvroEncoderKt.trySelectFixedSchemaForSize(this, value.length()) || AvroEncoderKt.trySelectEnumSchemaForSymbol(this, value) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.BOOLEAN) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.INT) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.LONG) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.FLOAT) || AvroEncoderKt.trySelectTypeNameFromUnion(this, Schema.Type.DOUBLE))) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.BYTES, Schema.Type.FIXED, Schema.Type.ENUM};
            throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.BOOLEAN, typeArray);
        }
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 8: {
                this.encodeBooleanUnchecked(StringsKt.toBooleanStrict((String)value));
                break;
            }
            case 9: {
                this.encodeIntUnchecked(Integer.parseInt(value));
                break;
            }
            case 10: {
                this.encodeLongUnchecked(Long.parseLong(value));
                break;
            }
            case 11: {
                this.encodeFloatUnchecked(Float.parseFloat(value));
                break;
            }
            case 12: {
                this.encodeDoubleUnchecked(Double.parseDouble(value));
                break;
            }
            case 5: {
                this.encodeStringUnchecked(value);
                break;
            }
            case 4: {
                this.encodeBytesUnchecked(StringsKt.encodeToByteArray((String)value));
                break;
            }
            case 6: {
                this.encodeFixedUnchecked(AvroEncoderKt.ensureFixedSize(this, StringsKt.encodeToByteArray((String)value)));
                break;
            }
            case 7: {
                this.encodeEnumUnchecked(value);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.BYTES, Schema.Type.FIXED, Schema.Type.ENUM};
                throw AvroEncoderKt.unsupportedWriterTypeError(this, Schema.Type.BOOLEAN, typeArray);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.RECORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FIXED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.ENUM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.DOUBLE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

