/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecimal;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.AvroFixed;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.internal.AvroSchemaGenerationException;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/math/BigDecimal;", "<init>", "()V", "LOGICAL_TYPE_NAME", "", "converter", "Lorg/apache/avro/Conversions$DecimalConversion;", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "logicalType", "Lorg/apache/avro/LogicalTypes$Decimal;", "Lcom/github/avrokotlin/avro4k/AvroDecimal;", "getLogicalType", "(Lcom/github/avrokotlin/avro4k/AvroDecimal;)Lorg/apache/avro/LogicalTypes$Decimal;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaStdLibSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,283:1\n1#2:284\n104#3:285\n297#3,13:286\n*S KotlinDebug\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer\n*L\n238#1:285\n238#1:286,13\n*E\n"})
public final class BigDecimalSerializer
extends AvroSerializer<BigDecimal> {
    @NotNull
    public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();
    @NotNull
    public static final String LOGICAL_TYPE_NAME = "decimal";
    @NotNull
    private static final Conversions.DecimalConversion converter = new Conversions.DecimalConversion();

    private BigDecimalSerializer() {
        String string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        AvroStringable avroStringable;
        AvroStringable avroStringable2;
        LogicalTypes.Decimal logicalType;
        block5: {
            Object object;
            block4: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                for (Object it : (Iterable)context.getInlinedElements()) {
                    boolean bl = false;
                    if ((it = AvroSerializerKt.getDecimal((ElementLocation)it)) == null) continue;
                    object = it;
                    break block4;
                }
                object = null;
            }
            logicalType = object != null ? this.getLogicalType((AvroDecimal)object) : null;
            for (Object it : (Iterable)context.getInlinedElements()) {
                AvroStringable avroStringable3;
                boolean bl = false;
                AvroStringable avroStringable4 = AvroSerializerKt.getStringable((ElementLocation)it);
                if (avroStringable4 == null || (avroStringable4 = AvroSerializerKt.createSchema(avroStringable4)) == null) {
                    AvroFixed avroFixed = AvroSerializerKt.getFixed((ElementLocation)it);
                    avroStringable4 = avroFixed != null && (avroFixed = AvroSerializerKt.createSchema(avroFixed, (ElementLocation)it)) != null ? HelpersKt.copy$default((Schema)avroFixed, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, (LogicalType)BigDecimalSerializer.getSchema$nonNullLogicalType(logicalType), null, 49151, null) : null;
                }
                if ((avroStringable3 = avroStringable4) == null) continue;
                avroStringable2 = avroStringable3;
                break block5;
            }
            avroStringable2 = avroStringable = null;
        }
        if (avroStringable2 == null) {
            Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
            avroStringable = HelpersKt.copy$default(schema, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, (LogicalType)BigDecimalSerializer.getSchema$nonNullLogicalType(logicalType), null, 49151, null);
        }
        return avroStringable;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u242 = encoder;
        boolean bl = false;
        if ($this$serializeAvro_u24lambda_u242.getCurrentWriterSchema().isUnion()) {
            String string = converter.getLogicalTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogicalTypeName(...)");
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.FIXED};
            if (!(AvroEncoderKt.trySelectLogicalTypeFromUnion($this$serializeAvro_u24lambda_u242, string, typeArray) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u242, Schema.Type.STRING) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u242, Schema.Type.INT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u242, Schema.Type.LONG) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u242, Schema.Type.FLOAT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u242, Schema.Type.DOUBLE))) {
                typeArray = new Schema.Type[]{Schema.Type.FIXED, Schema.Type.STRING, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u242, Schema.Type.BYTES, typeArray);
            }
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u242.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                byte[] byArray = converter.toBytes(value, $this$serializeAvro_u24lambda_u242.getCurrentWriterSchema(), $this$serializeAvro_u24lambda_u242.getCurrentWriterSchema().getLogicalType()).array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                $this$serializeAvro_u24lambda_u242.encodeBytes(byArray);
                break;
            }
            case 2: {
                byte[] byArray = converter.toFixed(value, $this$serializeAvro_u24lambda_u242.getCurrentWriterSchema(), $this$serializeAvro_u24lambda_u242.getCurrentWriterSchema().getLogicalType()).bytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes(...)");
                $this$serializeAvro_u24lambda_u242.encodeFixed(byArray);
                break;
            }
            case 3: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u242.encodeString(string);
                break;
            }
            case 4: {
                $this$serializeAvro_u24lambda_u242.encodeInt(value.intValueExact());
                break;
            }
            case 5: {
                $this$serializeAvro_u24lambda_u242.encodeLong(value.longValueExact());
                break;
            }
            case 6: {
                $this$serializeAvro_u24lambda_u242.encodeFloat(value.floatValue());
                break;
            }
            case 7: {
                $this$serializeAvro_u24lambda_u242.encodeDouble(value.doubleValue());
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FIXED, Schema.Type.STRING, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u242, Schema.Type.BYTES, typeArray);
            }
        }
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public BigDecimal deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<BigDecimal> foundResolver$iv$iv;
        AnyValueDecoder<BigDecimal> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u248;
        block19: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u248 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u248;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema schema : (Iterable)list) {
                    AnyValueDecoder<BigDecimal> anyValueDecoder2;
                    AnyValueDecoder<BigDecimal> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = schema.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 3: {
                            anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$4(decoder, arg_0);
                            break;
                        }
                        case 1: {
                            if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                                anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$5(decoder, schema, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        case 2: {
                            if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                                anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$6(decoder, schema, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block19;
                }
                anyValueDecoder = null;
            } else {
                Schema schema = schema$iv$iv;
                boolean bl3 = false;
                Schema.Type type = schema.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 3: {
                        anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$4(decoder, arg_0);
                        break;
                    }
                    case 1: {
                        if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                            anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$5(decoder, schema, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    case 2: {
                        if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                            anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$8$lambda$7$lambda$6(decoder, schema, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<BigDecimal> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.FIXED};
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u248, "BigDecimal", Schema.Type.STRING, typeArray);
        }
        return anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
    }

    @Override
    @NotNull
    public BigDecimal deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return new BigDecimal(decoder.decodeString());
    }

    private final LogicalTypes.Decimal getLogicalType(AvroDecimal $this$logicalType) {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)$this$logicalType.precision(), (int)$this$logicalType.scale());
        Intrinsics.checkNotNullExpressionValue((Object)decimal, (String)"decimal(...)");
        return decimal;
    }

    private static final LogicalTypes.Decimal getSchema$nonNullLogicalType(LogicalTypes.Decimal logicalType) {
        if (logicalType == null) {
            throw new AvroSchemaGenerationException("BigDecimal requires @" + Reflection.getOrCreateKotlinClass(AvroDecimal.class).getQualifiedName() + " to works with 'fixed' or 'bytes' schema types.");
        }
        return logicalType;
    }

    private static final BigDecimal deserializeAvro$lambda$8$lambda$7$lambda$4(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return new BigDecimal($decoder.decodeString());
    }

    private static final BigDecimal deserializeAvro$lambda$8$lambda$7$lambda$5(AvroDecoder $decoder, Schema $schema, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigDecimal bigDecimal = converter.fromBytes(ByteBuffer.wrap($decoder.decodeBytes()), $schema, $schema.getLogicalType());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"fromBytes(...)");
        return bigDecimal;
    }

    private static final BigDecimal deserializeAvro$lambda$8$lambda$7$lambda$6(AvroDecoder $decoder, Schema $schema, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigDecimal bigDecimal = converter.fromFixed($decoder.decodeFixed(), $schema, $schema.getLogicalType());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"fromFixed(...)");
        return bigDecimal;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

