/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/BigIntegerSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/math/BigInteger;", "<init>", "()V", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaStdLibSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigIntegerSerializer\n+ 2 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,283:1\n104#2:284\n297#2,13:285\n*S KotlinDebug\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigIntegerSerializer\n*L\n126#1:284\n126#1:285,13\n*E\n"})
public final class BigIntegerSerializer
extends AvroSerializer<BigInteger> {
    @NotNull
    public static final BigIntegerSerializer INSTANCE = new BigIntegerSerializer();

    private BigIntegerSerializer() {
        String string = Reflection.getOrCreateKotlinClass(BigInteger.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
        return schema;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u240 = encoder;
        boolean bl = false;
        if (!(!$this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().isUnion() || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.STRING) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.INT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.LONG) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.FLOAT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.DOUBLE))) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
            throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.STRING, typeArray);
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u240.encodeString(string);
                break;
            }
            case 2: {
                $this$serializeAvro_u24lambda_u240.encodeInt(value.intValueExact());
                break;
            }
            case 3: {
                $this$serializeAvro_u24lambda_u240.encodeLong(value.longValueExact());
                break;
            }
            case 4: {
                $this$serializeAvro_u24lambda_u240.encodeFloat(value.floatValue());
                break;
            }
            case 5: {
                $this$serializeAvro_u24lambda_u240.encodeDouble(value.doubleValue());
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.STRING, typeArray);
            }
        }
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public BigInteger deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<BigInteger> foundResolver$iv$iv;
        AnyValueDecoder<BigInteger> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u248;
        block19: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u248 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u248;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema schema : (Iterable)list) {
                    AnyValueDecoder<BigInteger> anyValueDecoder2;
                    AnyValueDecoder<BigInteger> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = schema.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            anyValueDecoder3 = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$2(decoder, arg_0);
                            break;
                        }
                        case 2: {
                            anyValueDecoder3 = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$3(decoder, arg_0);
                            break;
                        }
                        case 3: {
                            anyValueDecoder3 = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$4(decoder, arg_0);
                            break;
                        }
                        case 4: {
                            anyValueDecoder3 = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$5(decoder, arg_0);
                            break;
                        }
                        case 5: {
                            anyValueDecoder3 = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$6(decoder, arg_0);
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block19;
                }
                anyValueDecoder = null;
            } else {
                Schema schema = schema$iv$iv;
                boolean bl3 = false;
                Schema.Type type = schema.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        anyValueDecoder = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$2(decoder, arg_0);
                        break;
                    }
                    case 2: {
                        anyValueDecoder = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$3(decoder, arg_0);
                        break;
                    }
                    case 3: {
                        anyValueDecoder = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$4(decoder, arg_0);
                        break;
                    }
                    case 4: {
                        anyValueDecoder = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$5(decoder, arg_0);
                        break;
                    }
                    case 5: {
                        anyValueDecoder = arg_0 -> BigIntegerSerializer.deserializeAvro$lambda$8$lambda$7$lambda$6(decoder, arg_0);
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<BigInteger> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u248, "BigInteger", Schema.Type.STRING, typeArray);
        }
        return anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
    }

    @Override
    @NotNull
    public BigInteger deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return new BigInteger(decoder.decodeString());
    }

    private static final BigInteger deserializeAvro$lambda$8$lambda$7$lambda$2(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return new BigInteger($decoder.decodeString());
    }

    private static final BigInteger deserializeAvro$lambda$8$lambda$7$lambda$3(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigInteger bigInteger = BigInteger.valueOf($decoder.decodeInt());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        return bigInteger;
    }

    private static final BigInteger deserializeAvro$lambda$8$lambda$7$lambda$4(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigInteger bigInteger = BigInteger.valueOf($decoder.decodeLong());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        return bigInteger;
    }

    private static final BigInteger deserializeAvro$lambda$8$lambda$7$lambda$5(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigInteger bigInteger = new BigDecimal(String.valueOf($decoder.decodeFloat())).toBigIntegerExact();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"toBigIntegerExact(...)");
        return bigInteger;
    }

    private static final BigInteger deserializeAvro$lambda$8$lambda$7$lambda$6(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        BigInteger bigInteger = new BigDecimal(String.valueOf($decoder.decodeDouble())).toBigIntegerExact();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"toBigIntegerExact(...)");
        return bigInteger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.DOUBLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

