/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal;

import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroFixed;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/internal/AvroByteArraySerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "", "<init>", "()V", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
final class AvroByteArraySerializer
extends AvroSerializer<byte[]> {
    @NotNull
    public static final AvroByteArraySerializer INSTANCE = new AvroByteArraySerializer();

    private AvroByteArraySerializer() {
        String string = Reflection.getOrCreateKotlinClass(byte[].class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Schema schema;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ElementLocation it : (Iterable)context.getInlinedElements()) {
                AvroStringable avroStringable;
                boolean bl = false;
                AvroStringable avroStringable2 = AvroSerializerKt.getStringable(it);
                if (avroStringable2 == null || (avroStringable2 = AvroSerializerKt.createSchema(avroStringable2)) == null) {
                    AvroFixed avroFixed = AvroSerializerKt.getFixed(it);
                    avroStringable2 = avroFixed != null ? AvroSerializerKt.createSchema(avroFixed, it) : null;
                }
                if ((avroStringable = avroStringable2) == null) continue;
                object = avroStringable;
                break block3;
            }
            object = schema = null;
        }
        if (object == null) {
            Schema schema2 = Schema.create((Schema.Type)Schema.Type.BYTES);
            schema = schema2;
            Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"create(...)");
        }
        return schema;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeBytes(value);
    }

    @Override
    @NotNull
    public byte[] deserializeAvro(@NotNull AvroDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return decoder.decodeBytes();
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeString(Base64.encode$default((Base64)Base64.Default.getMime(), (byte[])value, (int)0, (int)0, (int)6, null));
    }

    @Override
    @NotNull
    public byte[] deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return Base64.decode$default((Base64)Base64.Default.getMime(), (CharSequence)decoder.decodeString(), (int)0, (int)0, (int)6, null);
    }
}

