/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroDecoderKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.NumberUtilsKt;
import com.github.avrokotlin.avro4k.internal.SerializerLocatorMiddleware;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoderKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractInterceptingDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.ArrayBlockDirectDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.MapBlockDirectDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.PolymorphicDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.RecordAsMapDirectDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.direct.RecordDirectDecoder;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0007J!\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0014H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020'H\u0016J\u0014\u0010@\u001a\u00020\u0014*\u00020'2\u0006\u0010A\u001a\u00020=H\u0002J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020EH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u000eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006F"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/direct/AbstractAvroDirectDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/direct/AbstractInterceptingDecoder;", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryDecoder", "Lorg/apache/avro/io/Decoder;", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Decoder;)V", "getAvro$core", "()Lcom/github/avrokotlin/avro4k/Avro;", "getBinaryDecoder", "()Lorg/apache/avro/io/Decoder;", "currentWriterSchema", "Lorg/apache/avro/Schema;", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "decodedCollectionSize", "", "getDecodedCollectionSize$core", "()I", "setDecodedCollectionSize$core", "(I)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeValue", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeAndResolveUnion", "", "decodeNotNullMark", "", "decodeNull", "", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeFloat", "", "decodeDouble", "", "decodeChar", "", "decodeString", "", "decodeEnum", "enumDescriptor", "getEnumIndex", "enumName", "decodeBytes", "", "decodeFixed", "Lorg/apache/avro/generic/GenericFixed;", "core"})
public abstract class AbstractAvroDirectDecoder
extends AbstractInterceptingDecoder
implements AvroDecoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private final org.apache.avro.io.Decoder binaryDecoder;
    private int decodedCollectionSize;

    public AbstractAvroDirectDecoder(@NotNull Avro avro, @NotNull org.apache.avro.io.Decoder binaryDecoder) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryDecoder, (String)"binaryDecoder");
        this.avro = avro;
        this.binaryDecoder = binaryDecoder;
        this.decodedCollectionSize = -1;
    }

    @NotNull
    public final Avro getAvro$core() {
        return this.avro;
    }

    @NotNull
    protected final org.apache.avro.io.Decoder getBinaryDecoder() {
        return this.binaryDecoder;
    }

    @Override
    @NotNull
    public abstract Schema getCurrentWriterSchema();

    public abstract void setCurrentWriterSchema(@NotNull Schema var1);

    public final int getDecodedCollectionSize$core() {
        return this.decodedCollectionSize;
    }

    public final void setDecodedCollectionSize$core(int n) {
        this.decodedCollectionSize = n;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.avro.getSerializersModule();
    }

    @Override
    @Deprecated(message="Do not use it for direct encoding")
    @NotNull
    public final Object decodeValue() {
        throw new UnsupportedOperationException("Direct decoding doesn't support decoding generic values");
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        this.decodeAndResolveUnion();
        return (T)SerializerLocatorMiddleware.INSTANCE.apply(deserializer).deserialize((Decoder)this);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            Schema.Type type = this.getCurrentWriterSchema().getType();
            if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) != 1) {
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.ARRAY, new Schema.Type[0]);
            }
            compositeDecoder = new ArrayBlockDirectDecoder(this.getCurrentWriterSchema(), this.decodedCollectionSize == -1, (Function1<? super Integer, Unit>)((Function1)arg_0 -> AbstractAvroDirectDecoder.beginStructure$lambda$0(this, arg_0)), this.avro, this.binaryDecoder);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            AbstractAvroDirectDecoder abstractAvroDirectDecoder;
            Schema.Type type = this.getCurrentWriterSchema().getType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 2: {
                    abstractAvroDirectDecoder = new MapBlockDirectDecoder(this.getCurrentWriterSchema(), this.decodedCollectionSize == -1, (Function1<? super Integer, Unit>)((Function1)arg_0 -> AbstractAvroDirectDecoder.beginStructure$lambda$1(this, arg_0)), this.avro, this.binaryDecoder);
                    break;
                }
                case 3: {
                    abstractAvroDirectDecoder = new RecordAsMapDirectDecoder(this.getCurrentWriterSchema(), this.avro, this.binaryDecoder);
                    break;
                }
                default: {
                    throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.MAP, new Schema.Type[0]);
                }
            }
            compositeDecoder = abstractAvroDirectDecoder;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            Schema.Type type = this.getCurrentWriterSchema().getType();
            if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) != 3) {
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.RECORD, new Schema.Type[0]);
            }
            compositeDecoder = new RecordDirectDecoder(this.getCurrentWriterSchema(), descriptor, this.avro, this.binaryDecoder);
        } else if (serialKind instanceof PolymorphicKind) {
            compositeDecoder = (CompositeDecoder)new PolymorphicDecoder(this.avro, descriptor, this.getCurrentWriterSchema(), this.binaryDecoder);
        } else {
            throw new SerializationException("Unsupported descriptor for structure decoding: " + descriptor);
        }
        return compositeDecoder;
    }

    private final void decodeAndResolveUnion() {
        if (this.getCurrentWriterSchema().getType() == Schema.Type.UNION) {
            Object e = this.getCurrentWriterSchema().getTypes().get(this.binaryDecoder.readIndex());
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            this.setCurrentWriterSchema((Schema)e);
        }
    }

    public boolean decodeNotNullMark() {
        this.decodeAndResolveUnion();
        return this.getCurrentWriterSchema().getType() != Schema.Type.NULL;
    }

    @Nullable
    public Void decodeNull() {
        if (this.getCurrentWriterSchema().getType() != Schema.Type.NULL) {
            throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.NULL, new Schema.Type[0]);
        }
        this.binaryDecoder.readNull();
        return null;
    }

    public boolean decodeBoolean() {
        boolean bl;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 4: {
                bl = this.binaryDecoder.readBoolean();
                break;
            }
            case 5: {
                String string = this.binaryDecoder.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                bl = StringsKt.toBooleanStrict((String)string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.BOOLEAN, typeArray);
            }
        }
        return bl;
    }

    public byte decodeByte() {
        return NumberUtilsKt.toByteExact(this.decodeInt());
    }

    public short decodeShort() {
        return NumberUtilsKt.toShortExact(this.decodeInt());
    }

    public int decodeInt() {
        int n;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 6: {
                n = this.binaryDecoder.readInt();
                break;
            }
            case 7: {
                n = NumberUtilsKt.toIntExact(this.binaryDecoder.readLong());
                break;
            }
            case 5: {
                String string = this.binaryDecoder.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                n = Integer.parseInt(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
            }
        }
        return n;
    }

    public long decodeLong() {
        long l;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 7: {
                l = this.binaryDecoder.readLong();
                break;
            }
            case 6: {
                l = this.binaryDecoder.readInt();
                break;
            }
            case 5: {
                String string = this.binaryDecoder.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                l = Long.parseLong(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.INT, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.LONG, typeArray);
            }
        }
        return l;
    }

    public float decodeFloat() {
        float f;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 8: {
                f = this.binaryDecoder.readFloat();
                break;
            }
            case 9: {
                f = NumberUtilsKt.toFloatExact(this.binaryDecoder.readDouble());
                break;
            }
            case 5: {
                String string = this.binaryDecoder.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                f = Float.parseFloat(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.DOUBLE, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.FLOAT, typeArray);
            }
        }
        return f;
    }

    public double decodeDouble() {
        double d;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 8: {
                d = this.binaryDecoder.readFloat();
                break;
            }
            case 9: {
                d = this.binaryDecoder.readDouble();
                break;
            }
            case 5: {
                String string = this.binaryDecoder.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                d = Double.parseDouble(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.DOUBLE, typeArray);
            }
        }
        return d;
    }

    public char decodeChar() {
        char c;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 6: {
                c = (char)this.binaryDecoder.readInt();
                break;
            }
            case 5: {
                Utf8 utf8 = this.binaryDecoder.readString(null);
                Intrinsics.checkNotNullExpressionValue((Object)utf8, (String)"readString(...)");
                c = StringsKt.single((CharSequence)((CharSequence)utf8));
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.INT, typeArray);
            }
        }
        return c;
    }

    @NotNull
    public String decodeString() {
        String string;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 5: {
                String string2 = this.binaryDecoder.readString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                break;
            }
            case 10: {
                string = StringsKt.decodeToString((byte[])AbstractAvroDirectDecoderKt.access$readBytes(this.binaryDecoder));
                break;
            }
            case 11: {
                string = StringsKt.decodeToString((byte[])AbstractAvroDirectDecoderKt.access$readFixedBytes(this.binaryDecoder, this.getCurrentWriterSchema().getFixedSize()));
                break;
            }
            case 4: {
                string = String.valueOf(this.binaryDecoder.readBoolean());
                break;
            }
            case 6: {
                string = String.valueOf(this.binaryDecoder.readInt());
                break;
            }
            case 7: {
                string = String.valueOf(this.binaryDecoder.readLong());
                break;
            }
            case 8: {
                string = String.valueOf(this.binaryDecoder.readFloat());
                break;
            }
            case 9: {
                string = String.valueOf(this.binaryDecoder.readDouble());
                break;
            }
            case 12: {
                Object e = this.getCurrentWriterSchema().getEnumSymbols().get(this.binaryDecoder.readEnum());
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                string = (String)e;
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.FIXED, Schema.Type.BOOLEAN, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.ENUM};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.STRING, typeArray);
            }
        }
        return string;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 12: {
                if (HelpersKt.isFullNameOrAliasMatch(this.getCurrentWriterSchema(), enumDescriptor)) {
                    String enumSymbol = (String)this.getCurrentWriterSchema().getEnumSymbols().get(this.binaryDecoder.readEnum());
                    Intrinsics.checkNotNull((Object)enumSymbol);
                    n = this.getEnumIndex(enumDescriptor, enumSymbol);
                    break;
                }
                Schema.Type[] enumSymbol = new Schema.Type[]{Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.ENUM, enumSymbol);
            }
            case 5: {
                String enumSymbol = this.binaryDecoder.readString();
                Intrinsics.checkNotNull((Object)enumSymbol);
                n = this.getEnumIndex(enumDescriptor, enumSymbol);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.ENUM, typeArray);
            }
        }
        return n;
    }

    private final int getEnumIndex(SerialDescriptor $this$getEnumIndex, String enumName) {
        int n;
        int idx = $this$getEnumIndex.getElementIndex(enumName);
        if (idx >= 0) {
            n = idx;
        } else {
            Integer n2 = this.avro.getEnumResolver$core().getDefaultValueIndex($this$getEnumIndex);
            if (n2 != null) {
                n = n2;
            } else {
                throw new SerializationException("Unknown enum symbol name '" + enumName + "' for Enum '" + $this$getEnumIndex.getSerialName() + "' for writer schema " + this.getCurrentWriterSchema());
            }
        }
        return n;
    }

    @Override
    @NotNull
    public byte[] decodeBytes() {
        byte[] byArray;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                byArray = AbstractAvroDirectDecoderKt.access$readBytes(this.binaryDecoder);
                break;
            }
            case 11: {
                byArray = AbstractAvroDirectDecoderKt.access$readFixedBytes(this.binaryDecoder, this.getCurrentWriterSchema().getFixedSize());
                break;
            }
            case 5: {
                byte[] byArray2 = this.binaryDecoder.readString(null).getBytes();
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FIXED, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.BYTES, typeArray);
            }
        }
        return byArray;
    }

    @Override
    @NotNull
    public GenericFixed decodeFixed() {
        GenericFixed genericFixed;
        Schema.Type type = this.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                genericFixed = (GenericFixed)new GenericData.Fixed(this.getCurrentWriterSchema(), AbstractAvroDirectDecoderKt.access$readBytes(this.binaryDecoder));
                break;
            }
            case 11: {
                genericFixed = (GenericFixed)new GenericData.Fixed(this.getCurrentWriterSchema(), AbstractAvroDirectDecoderKt.access$readFixedBytes(this.binaryDecoder, this.getCurrentWriterSchema().getFixedSize()));
                break;
            }
            case 5: {
                genericFixed = (GenericFixed)new GenericData.Fixed(this.getCurrentWriterSchema(), this.binaryDecoder.readString(null).getBytes());
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.STRING};
                throw AvroDecoderKt.unsupportedWriterTypeError(this, Schema.Type.FIXED, typeArray);
            }
        }
        return genericFixed;
    }

    private static final Unit beginStructure$lambda$0(AbstractAvroDirectDecoder this$0, int it) {
        this$0.decodedCollectionSize = it;
        return Unit.INSTANCE;
    }

    private static final Unit beginStructure$lambda$1(AbstractAvroDirectDecoder this$0, int it) {
        this$0.decodedCollectionSize = it;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.RECORD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.DOUBLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FIXED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.ENUM.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

