/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.Decoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/direct/RecordAsMapDirectDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/direct/AbstractAvroDirectDecoder;", "writerRecordSchema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryDecoder", "Lorg/apache/avro/io/Decoder;", "<init>", "(Lorg/apache/avro/Schema;Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Decoder;)V", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "fieldNameToRead", "", "decodeCollectionSize", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "beginElement", "", "index", "decodeString", "decodeSequentially", "", "decodeElementIndex", "decodeBoolean", "decodeByte", "", "decodeBytes", "", "decodeChar", "", "decodeFixed", "Lorg/apache/avro/generic/GenericFixed;", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeFloat", "", "decodeNull", "", "decodeDouble", "", "ensureNotFieldNameDecoding", "Companion", "core"})
public final class RecordAsMapDirectDecoder
extends AbstractAvroDirectDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Schema writerRecordSchema;
    public Schema currentWriterSchema;
    @Nullable
    private String fieldNameToRead;
    private static final Schema KEY_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);

    public RecordAsMapDirectDecoder(@NotNull Schema writerRecordSchema, @NotNull Avro avro, @NotNull Decoder binaryDecoder) {
        Intrinsics.checkNotNullParameter((Object)writerRecordSchema, (String)"writerRecordSchema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryDecoder, (String)"binaryDecoder");
        super(avro, binaryDecoder);
        this.writerRecordSchema = writerRecordSchema;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.writerRecordSchema.getFields().size();
    }

    @Override
    protected void beginElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Schema.Field field = (Schema.Field)this.writerRecordSchema.getFields().get(index / 2);
        if (index % 2 == 0) {
            Schema schema = KEY_SCHEMA;
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"KEY_SCHEMA");
            this.setCurrentWriterSchema(schema);
            this.fieldNameToRead = field.name();
        } else {
            Schema schema = field.schema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
            this.setCurrentWriterSchema(schema);
            this.fieldNameToRead = null;
        }
    }

    @Override
    @NotNull
    public String decodeString() {
        String string = this.fieldNameToRead;
        if (string == null) {
            string = super.decodeString();
        }
        return string;
    }

    @Override
    public boolean decodeSequentially() {
        return true;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw ExceptionsKt.IllegalIndexedAccessError(this);
    }

    @Override
    public boolean decodeBoolean() {
        this.ensureNotFieldNameDecoding();
        return super.decodeBoolean();
    }

    @Override
    public byte decodeByte() {
        this.ensureNotFieldNameDecoding();
        return super.decodeByte();
    }

    @Override
    @NotNull
    public byte[] decodeBytes() {
        this.ensureNotFieldNameDecoding();
        return super.decodeBytes();
    }

    @Override
    public char decodeChar() {
        this.ensureNotFieldNameDecoding();
        return super.decodeChar();
    }

    @Override
    @NotNull
    public GenericFixed decodeFixed() {
        this.ensureNotFieldNameDecoding();
        return super.decodeFixed();
    }

    @Override
    public short decodeShort() {
        this.ensureNotFieldNameDecoding();
        return super.decodeShort();
    }

    @Override
    public int decodeInt() {
        this.ensureNotFieldNameDecoding();
        return super.decodeInt();
    }

    @Override
    public long decodeLong() {
        this.ensureNotFieldNameDecoding();
        return super.decodeLong();
    }

    @Override
    public float decodeFloat() {
        this.ensureNotFieldNameDecoding();
        return super.decodeFloat();
    }

    @Override
    @Nullable
    public Void decodeNull() {
        this.ensureNotFieldNameDecoding();
        return super.decodeNull();
    }

    @Override
    public double decodeDouble() {
        this.ensureNotFieldNameDecoding();
        return super.decodeDouble();
    }

    private final void ensureNotFieldNameDecoding() {
        if (this.fieldNameToRead != null) {
            throw new UnsupportedOperationException("Misused decoding: expected to decode the field name");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/direct/RecordAsMapDirectDecoder$Companion;", "", "<init>", "()V", "KEY_SCHEMA", "Lorg/apache/avro/Schema;", "kotlin.jvm.PlatformType", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

