/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.decoder.generic.AbstractAvroGenericDecoder;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/generic/MapGenericDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder;", "map", "", "", "", "writerSchema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Ljava/util/Map;Lorg/apache/avro/Schema;Lcom/github/avrokotlin/avro4k/Avro;)V", "getAvro$core", "()Lcom/github/avrokotlin/avro4k/Avro;", "iterator", "", "Lkotlin/Pair;", "", "currentData", "decodedNotNullMark", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "decodeNotNullMark", "decodeValue", "decodeNull", "", "decodeElementIndex", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeCollectionSize", "decodeSequentially", "Companion", "core"})
public final class MapGenericDecoder
extends AbstractAvroGenericDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<CharSequence, Object> map;
    @NotNull
    private final Schema writerSchema;
    @NotNull
    private final Avro avro;
    @NotNull
    private final Iterator<Pair<Boolean, Object>> iterator;
    private Pair<Boolean, ? extends Object> currentData;
    private boolean decodedNotNullMark;
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);

    public MapGenericDecoder(@NotNull Map<CharSequence, ? extends Object> map, @NotNull Schema writerSchema, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.map = map;
        this.writerSchema = writerSchema;
        this.avro = avro;
        this.iterator = SequencesKt.flatMap((Sequence)MapsKt.asSequence(this.map), MapGenericDecoder::iterator$lambda$0).iterator();
    }

    @Override
    @NotNull
    public Avro getAvro$core() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema;
        Pair<Boolean, ? extends Object> pair = this.currentData;
        if (pair == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentData");
            pair = null;
        }
        if (((Boolean)pair.getFirst()).booleanValue()) {
            Schema schema2 = STRING_SCHEMA;
            Intrinsics.checkNotNull((Object)schema2);
            schema = schema2;
        } else {
            Schema schema3 = this.writerSchema.getValueType();
            Intrinsics.checkNotNull((Object)schema3);
            schema = schema3;
        }
        return schema;
    }

    @Override
    public boolean decodeNotNullMark() {
        this.decodedNotNullMark = true;
        this.currentData = this.iterator.next();
        Pair<Boolean, ? extends Object> pair = this.currentData;
        if (pair == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentData");
            pair = null;
        }
        return pair.getSecond() != null;
    }

    @Override
    @NotNull
    public Object decodeValue() {
        Pair<Boolean, ? extends Object> pair;
        if (!this.decodedNotNullMark) {
            this.currentData = this.iterator.next();
        } else {
            this.decodedNotNullMark = false;
        }
        if ((pair = this.currentData) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentData");
            pair = null;
        }
        Object object = pair.getSecond();
        if (object == null) {
            throw ExceptionsKt.DecodedNullError(this);
        }
        return object;
    }

    @Nullable
    public Void decodeNull() {
        this.decodedNotNullMark = false;
        return null;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw ExceptionsKt.IllegalIndexedAccessError(this);
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.map.size();
    }

    public boolean decodeSequentially() {
        return true;
    }

    private static final Sequence iterator$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)true, it.getKey()), TuplesKt.to((Object)true, it.getValue())};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/generic/MapGenericDecoder$Companion;", "", "<init>", "()V", "STRING_SCHEMA", "Lorg/apache/avro/Schema;", "kotlin.jvm.PlatformType", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

